package com.elitesland.yst.production.fin.infr.dto.payorder;

import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:49
 */
@Data
public class PayOrderDTO implements Serializable {

    private static final long serialVersionUID = -1123102269530735364L;
    private Long id;

    private String sourceNo;

    private Long suppId;

    private String suppCode;

    private String suppName;

    private String ouCode;

    private Long ouId;

    private String ouName;

    private Long apTypeId;

    private String apTypeName;

    private String apTypeCode;

    private Long payTypeId;

    private String payTypeCode;

    private String payTypeName;

    private String payOrderNo;

    private String currCode;

    private String currName;

    private String operator;

    private Long operUserId;

    private String buType;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private LocalDateTime buDate;

    private Long auditUserId;

    private String auditUser;

    private LocalDateTime auditDate;

    private String orderState;

    private BigDecimal exchangeRate;

    private Boolean initFlag;

    private BigDecimal realPayAmt;

    private BigDecimal realPayCurAmt;

    private LocalDateTime apDate;

    private Boolean apFlag;

    private String creator;

    private LocalDateTime createTime;

    private String updater;

    private LocalDateTime modifyTime;

    private String remark;

    private String auditRejection;

    private String createMode;

    private String localCurrCode;

    private String localCurrName;

    private String verState;

    private BigDecimal verAmt;

    private Integer auditDataVersion;

    private String procInstId;

    private ProcInstStatus procInstStatus;

    private LocalDateTime submitTime;

    private LocalDateTime approvedTime;

    private String addrNo;

    private String suppAddrNo;

    @ApiModelProperty("明细集合")
    private List<PayOrderDtlDTO> payOrderDtlVOList;
}
