package com.elitesland.yst.production.fin.infr.repo.aptype;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.yst.production.fin.domain.entity.aptype.QApTypeDO;
import com.elitesland.yst.production.fin.domain.param.aptype.ApTypePageParam;
import com.elitesland.yst.production.fin.infr.dto.aptype.ApTypeDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.infr.repo.aptype
 * @date 2022/3/11 16:59
 */
@Component
@RequiredArgsConstructor
public class ApTypeRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QApTypeDO qApTypeDO = QApTypeDO.apTypeDO;


    public PagingVO<ApTypeDTO> page(ApTypePageParam apType, List<Long> ids) {

        // 条件拼接
        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotBlank(apType.getApTypeCode())) {
            predicates.add(qApTypeDO.apTypeCode.like('%' + apType.getApTypeCode() + '%'));
        }
        if (StringUtils.isNotBlank(apType.getApTypeName())) {
            predicates.add(qApTypeDO.apTypeName.like('%' + apType.getApTypeName() + '%'));
        }
        // 公司ouid的查询条件
        if (null != apType.getOuId()) {
            if (CollUtil.isNotEmpty(ids)) {
                predicates.add(qApTypeDO.id.in(ids));
            } else {
                return new PagingVO<>();
            }
        }
        predicates.add(qApTypeDO.deleteFlag.eq(0));
        JPAQuery<ApTypeDTO> query = select(ApTypeDTO.class).where(ExpressionUtils.allOf(predicates));
        apType.setPaging(query);
        apType.fillOrders(query, qApTypeDO);

        return PagingVO.<ApTypeDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public <T> JPAQuery<T> select(Class<T> T) {
        return jpaQueryFactory.select(Projections.bean(T,
                qApTypeDO.id,
                qApTypeDO.apTypeCode,
                qApTypeDO.apTypeName,
                qApTypeDO.enableFlag,
                qApTypeDO.defaultFlag,
                qApTypeDO.createTime))
                .from(qApTypeDO);
    }

    public void updateEnableFlag(List<Long> ids, Boolean enable) {
        jpaQueryFactory.update(qApTypeDO)
                .set(qApTypeDO.enableFlag, enable)
                .where(qApTypeDO.id.in(ids))
                .execute();
    }

    public Long updateDef() {
        long execute = jpaQueryFactory.update(qApTypeDO)
                .set(qApTypeDO.defaultFlag, false)
                .where(qApTypeDO.defaultFlag.isTrue())
                .execute();
        return execute;
    }

    public Long updateDefById(Long id) {
        long execute = jpaQueryFactory.update(qApTypeDO)
                .set(qApTypeDO.defaultFlag, true)
                .where(qApTypeDO.id.eq(id))
                .execute();
        return execute;
    }


    public Long del(Long id) {
        long execute = jpaQueryFactory.delete(qApTypeDO)
                .where(qApTypeDO.id.eq(id))
                .execute();
        return execute;
    }

    public ApTypeDTO findById(Long id) {
        ApTypeDTO apTypeDTO = select(ApTypeDTO.class)
                .where(qApTypeDO.id.eq(id)).fetchOne();
        return apTypeDTO;
    }

    public Boolean isFir() {
        long res = select(ApTypeDTO.class)
                .where(qApTypeDO.deleteFlag.eq(0))
                .fetchCount();
        return res == 0;
    }

    public List<ApTypeDTO> findByIds(List<Long> ids) {
        List<ApTypeDTO> res = select(ApTypeDTO.class)
                .where(qApTypeDO.id.in(ids)).fetch();
        return res;
    }

    public Boolean existsByApTypeCode(String apTypeCode) {
        long count = select(ApTypeDTO.class)
                .where(qApTypeDO.apTypeCode.eq(apTypeCode))
                .fetchCount();
        return count > 0;
    }

    public Boolean existsByApTypeName(String apTypeName) {
        long count = select(ApTypeDTO.class)
                .where(qApTypeDO.apTypeName.eq(apTypeName))
                .fetchCount();
        return count > 0;
    }

    public ApTypeDTO getDef() {
        ApTypeDTO apTypeDTO = select(ApTypeDTO.class)
                .where(qApTypeDO.defaultFlag.eq(true))
                .where(qApTypeDO.deleteFlag.eq(0))
                .where(qApTypeDO.enableFlag.eq(true))
                .fetchOne();
        return apTypeDTO;
    }

    public List<ApTypeDTO> getList() {
        List<ApTypeDTO> res = select(ApTypeDTO.class)
                .where(qApTypeDO.deleteFlag.eq(0))
                .where(qApTypeDO.enableFlag.eq(true))
                .fetch();
        return res;
    }
}
