package com.elitesland.yst.production.fin.provider.inputinv;

import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.production.fin.Application;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.yst.production.fin.application.convert.inputinv.InputInvConvert;
import com.elitesland.yst.production.fin.domain.entity.inputinv.InputInv;
import com.elitesland.yst.production.fin.domain.service.inputinv.InputInvDomainService;
import com.elitesland.yst.production.fin.param.inputinv.InputInvRpcParam;
import com.elitesland.yst.production.fin.service.arorder.ArOrderRpcService;
import com.elitesland.yst.production.fin.service.inputinv.InputInvRpcService;
import com.elitescloud.boot.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.provider.inputinv
 * @date 2022/5/20 10:23
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + InputInvRpcService.PATH)
public class InputInvRpcServiceImpl implements InputInvRpcService {

    public final InputInvDomainService inputInvDomainService;

    @Override
    public Long save(InputInvRpcParam inputInvRpcParam) {
        if (CharSequenceUtil.isBlank(inputInvRpcParam.getCreateMode())) {
            throw new BusinessException("来源单据 createMode不能为空");
        }
        InputInv inputInv = InputInvConvert.INSTANCE.convertRpc(inputInvRpcParam);
        Long resId = inputInvDomainService.save(inputInv);
        return resId;
    }
}
