/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.domain.service.rectype;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.application.convert.rectype.RecTypeConvert;
import com.elitesland.yst.production.fin.domain.entity.rectype.RecType;
import com.elitesland.yst.production.fin.domain.entity.rectype.RecTypeDO;
import com.elitesland.yst.production.fin.domain.param.rectype.RecTypePageParam;
import com.elitesland.yst.production.fin.domain.service.rectype.RecTypeDomainService;
import com.elitesland.yst.production.fin.infr.dto.rectype.RecTypeDTO;
import com.elitesland.yst.production.fin.infr.factory.rectype.RecTypeFactory;
import com.elitesland.yst.production.fin.infr.repo.rectype.RecTypeRepo;
import com.elitesland.yst.production.fin.infr.repo.rectype.RecTypeRepoProc;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecTypeDomainServiceImpl
implements RecTypeDomainService {
    private final RecTypeRepo reTypeRepo;
    private final RecTypeRepoProc recTypeRepoProc;
    private final RecTypeFactory recTypeFactory;

    @Override
    public PagingVO<RecTypeDTO> page(RecTypePageParam param) {
        return this.recTypeFactory.payTypePage(param);
    }

    @Override
    public RecTypeDTO queryById(Long id) {
        return this.recTypeRepoProc.queryById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long makeDefault(Long id) {
        List<RecTypeDTO> dtos = this.recTypeRepoProc.findByIds(List.of(id));
        dtos.forEach(dto -> {
            if (dto.getDefaultFlag().booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u9ed8\u8ba4\u72b6\u6001\u4e0d\u80fd\u5728\u9ed8\u8ba4");
            }
        });
        this.recTypeRepoProc.updateDefault();
        return this.recTypeRepoProc.updateDefaultById(id, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> delete(List<Long> id) {
        List<RecTypeDTO> dtos = this.recTypeRepoProc.findByIds(id);
        dtos.forEach(dto -> {
            if (dto.getEnableFlag().booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u5220\u9664\u672a\u542f\u7528\u7684\u6570\u636e");
            }
            if (dto.getDefaultFlag().booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u9ed8\u8ba4\u7c7b\u578b\u4e0d\u80fd\u5220\u9664");
            }
        });
        this.recTypeRepoProc.delete(id);
        return id;
    }

    @Override
    public List<RecTypeDTO> findAll() {
        return this.recTypeRepoProc.findAll();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> stopEnable(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u4e2d\u6570\u636e!");
        }
        List<RecTypeDTO> dtos = this.recTypeRepoProc.findByIds(ids);
        dtos.forEach(dto -> {
            if (!dto.getEnableFlag().booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u505c\u7528\u72b6\u6001\u4e0d\u80fd\u5728\u505c\u7528");
            }
        });
        this.recTypeRepoProc.updateEnable(ids, false);
        return ids;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> enable(List<Long> ids) {
        this.recTypeRepoProc.updateEnable(ids, true);
        return ids;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(RecType recType) {
        recType.checkNotNull();
        if (recType.getId() == null) {
            Boolean existCode = this.recTypeRepoProc.existRecCode(recType.getRecTypeCode());
            if (existCode.booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6536\u6b3e\u5355\u7c7b\u578b\u7f16\u7801\u5df2\u5b58\u5728");
            }
            Boolean existName = this.recTypeRepoProc.existRecName(recType.getRecTypeName());
            if (existName.booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6536\u6b3e\u5355\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728");
            }
            if (this.recTypeRepoProc.isFirst().booleanValue()) {
                recType.setDefault(false);
            } else {
                recType.setDefault(true);
            }
        }
        RecTypeDO typeDO = RecTypeConvert.INSTANCE.convert(recType);
        RecTypeDO typeDO1 = (RecTypeDO)this.reTypeRepo.save(typeDO);
        return typeDO1.getId();
    }

    @Override
    public RecTypeDTO defaultValue() {
        return this.recTypeRepoProc.defaultValue();
    }

    @Override
    public Boolean getAuto(Long id) {
        return this.recTypeRepoProc.queryIsAutoAudit(id);
    }

    @Override
    public List<RecTypeDTO> queryByIds(Collection<Long> ids) {
        return this.recTypeRepoProc.findByIds(ids);
    }

    public RecTypeDomainServiceImpl(RecTypeRepo reTypeRepo, RecTypeRepoProc recTypeRepoProc, RecTypeFactory recTypeFactory) {
        this.reTypeRepo = reTypeRepo;
        this.recTypeRepoProc = recTypeRepoProc;
        this.recTypeFactory = recTypeFactory;
    }
}

