package com.elitesland.yst.production.fin.application.facade.vo.artype;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.application.facade.vo.artype
 * @date 2022/4/11 17:12
 */
@Data
public class ArTypeOuVO implements Serializable {

    private static final long serialVersionUID = -4299395419902491498L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("应收单类型定义ID")
    private Long arTypeId;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("公司类型")
    @SysCode(sys = "yst-supp", mod = "OU_TYPE")
    private String ouType;
    private String ouTypeName;
}
