package com.elitesland.yst.production.fin.domain.entity.aptype;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-3-14
 * @desc : 应付单类型定义对应公司
 */
@Entity
@Table(name="ap_type_ou")
@org.hibernate.annotations.Table(appliesTo = "ap_type_ou", comment = "应付单类型定义对应公司")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ApTypeOuDO extends BaseModel implements Serializable {


    private static final long serialVersionUID = -2878497823948652080L;
    @Column(name = "ap_type_id", columnDefinition = "bigint(20) comment '应付单类型定义ID'")
    private Long apTypeId;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_name", columnDefinition = "varchar(50) comment '公司名称'")
    private String ouName;

    @Column(name = "ou_code", columnDefinition = "varchar(20) comment '公司编号'")
    private String ouCode;

    @Column(name = "ou_type", columnDefinition = "varchar(20) comment '公司类型'")
    private String ouType;



    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApTypeOuDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApTypeOuDO entity = (ApTypeOuDO) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}