package com.elitesland.yst.production.fin.domain.entity.apverrec;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-4-20
 * @desc : 应付核销记录明细
 */
@Entity
@Table(name="ap_ver_rec_dtl")
@org.hibernate.annotations.Table(appliesTo = "ap_ver_rec_dtl", comment = "应付核销记录明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ApVerRecDtlDO extends BaseModel implements Serializable {


    private static final long serialVersionUID = 1214310158773603232L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '总单ID'")
    private Long masId;

    @Column(name = "ver_no", columnDefinition = "varchar(20) comment '核销编号'")
    private String verNo;

    @Column(name = "ver_date", columnDefinition = "datetime(6) comment '核销日期'")
    private LocalDateTime verDate;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(40) comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(200) comment '公司名称'")
    private String ouName;

    @Column(name = "order_name", columnDefinition = "varchar(40) comment '单据名称'")
    private String orderName;

    @Column(name = "order_no", columnDefinition = "varchar(20) comment '单据编号'")
    private String orderNo;

    @Column(name = "order_type", columnDefinition = "varchar(20) comment '单据类型'")
    private String orderType;

    @Column(name = "order_id", columnDefinition = "bigint(20) comment '单据ID'")
    private Long orderId;

    @Column(name = "supp_id", columnDefinition = "bigint(20) comment '供应商ID'")
    private Long suppId;

    @Column(name = "supp_code", columnDefinition = "varchar(40) comment '供应商编码'")
    private String suppCode;

    @Column(name = "supp_name", columnDefinition = "varchar(200) comment '供应商名称'")
    private String suppName;

    @Column(name = "bu_date", columnDefinition = "datetime(6) comment '业务日期'")
    private LocalDateTime buDate;

    @Column(name = "curr_code", columnDefinition = "varchar(20) comment '币种编码'")
    private String currCode;

    @Column(name = "curr_name", columnDefinition = "varchar(20) comment '币种'")
    private String currName;

    @Column(name = "amt", columnDefinition = "decimal(18,8) comment '本次核销金额'")
    private BigDecimal amt;

    @Column(name = "verify_type", columnDefinition = "varchar(20) comment '核销方式'")
    private String verifyType;

    @Column(name = "scheme_no", columnDefinition = "varchar(20) comment '核销方案编号'")
    private String schemeNo;

    @Column(name = "scheme_name", columnDefinition = "varchar(50) comment '核销方案名称'")
    private String schemeName;

    @Column(name = "scheme_id", columnDefinition = "bigint(20) comment '核销方案ID'")
    private Long schemeId;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApVerRecDtlDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApVerRecDtlDO entity = (ApVerRecDtlDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}