package com.elitesland.yst.production.fin.domain.service.payorder;

import com.elitesland.yst.production.fin.domain.param.payorder.PayOrderDtlPageParam;
import com.elitesland.yst.production.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.Collection;
import java.util.List;


/**
 * @author zhiyu.he
 * @date 2022/3/16 9:53
 */
public interface PayOrderDtlDomainService {

    /**
     * 根据付款单ID分页查询明细信息
     * @param param
     * @return
     */
    PagingVO<PayOrderDtlDTO> page(PayOrderDtlPageParam param);

    /**
     * 根据主键ID查询数据
     * @param ids 主键ID
     * @return 明细表数据
     */
    List<PayOrderDtlDTO> queryById(List<Long> ids);

    /**
     * 根据总单ID查询数据
     * @param masIds 总单ID集合
     * @return 明细表数据
     */
    List<PayOrderDtlDTO> queryByMasId(Collection<Long> masIds);


}
