package com.elitesland.yst.production.fin.provider.recorder;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.fin.Application;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.yst.production.fin.application.convert.recorder.RecOrderConvert;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.domain.entity.recorder.RecOrder;
import com.elitesland.yst.production.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.yst.production.fin.param.recorder.RecOrderRpcParam;
import com.elitesland.yst.production.fin.service.recorder.RecOrderRpcService;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.provider.recorder
 * @date 2022/5/19 10:14
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + RecOrderRpcService.PATH)
public class RecOrderRpcServiceImpl implements RecOrderRpcService {

    public final RecOrderDomainService recOrderDomainService;

    @Override
    public Long save(RecOrderRpcParam recOrderRpcParam) {
        if (CharSequenceUtil.isBlank(recOrderRpcParam.getCreateMode())) {
            throw new BusinessException("来源单据 createMode不能为空");
        }
        RecOrder recOrder = RecOrderConvert.INSTANCE.convertRpc(recOrderRpcParam);
        recOrder.setOrderState(UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode());
        Long resId = recOrderDomainService.save(recOrder);
        return resId;
    }
}
