package com.elitesland.yst.production.fin.repo.picturefile;

import com.elitesland.yst.production.fin.application.facade.vo.picturefile.PictureFileVO;
import com.elitesland.yst.production.fin.entity.picturefile.QPictureFileDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/20 15:03
 */
@Component
@RequiredArgsConstructor
public class PictureFileRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QPictureFileDO qPictureFileDO = QPictureFileDO.pictureFileDO;

    public List<PictureFileVO> queryBySourceIds(List<Long> sourceIds){
      return   select(PictureFileVO.class)
                .where(qPictureFileDO.sourceId.in(sourceIds))
                .fetch();
    }
    public  void  deleteBySourceId(List<Long> sourceIds){
        jpaQueryFactory.delete(qPictureFileDO)
                .where(qPictureFileDO.sourceId.in(sourceIds))
                .execute();
    }

    public PictureFileVO queryByCodeAndType(String code,String sourceType){
        return   select(PictureFileVO.class)
                .where(qPictureFileDO.code.eq(code))
                .where(qPictureFileDO.sourceType.eq(sourceType))
                .fetchOne();
    }
    public  List<PictureFileVO> queryBySourceIdsAndType(List<Long> sourceIds,String sourceType){
        return   select(PictureFileVO.class)
                .where(qPictureFileDO.sourceId.in(sourceIds))
                .where(qPictureFileDO.sourceType.eq(sourceType))
                .fetch();
    }
    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qPictureFileDO.id,
                qPictureFileDO.sourceId,
                qPictureFileDO.sourceType,
                qPictureFileDO.code,
                qPictureFileDO.url,
                qPictureFileDO.fileInfo,
                qPictureFileDO.fileName,
                qPictureFileDO.fileSize,
                qPictureFileDO.oldFileName
        )).from(qPictureFileDO);
    }
}
