package com.elitesland.yst.production.fin.application.facade.param.adjustorder;

import com.elitesland.yst.production.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2023/2/25 10:47
 */
@Data
@ApiModel(description = "调整单")
public class AdjustOrderParam extends BaseModelParam {
    private static final long serialVersionUID = 2526557077093215197L;
    @ApiModelProperty("单号")
    private String docNo;

    @ApiModelProperty("状态")
    private String state;

    @ApiModelProperty("单据类型")
    private String type;

    @ApiModelProperty("记账时间")
    private LocalDateTime recAccTime;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户类型")
    private String accType;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核人id")
    private Long auditUserId;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditTime;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejectReason;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("调整原因")
    private String adjReason;

    @ApiModelProperty("调整类型")
    private String adjType;

}
