package com.elitesland.yst.production.fin.application.service.artype;

import com.elitesland.yst.production.fin.application.convert.artype.ArTypeOuConvert;
import com.elitesland.yst.production.fin.application.facade.param.artype.ArTypeOuParam;
import com.elitesland.yst.production.fin.application.facade.param.artype.ArTypeOuSaveParam;
import com.elitesland.yst.production.fin.application.facade.vo.artype.ArTypeOuVO;
import com.elitesland.yst.production.fin.domain.entity.artype.ArTypeOu;
import com.elitesland.yst.production.fin.domain.param.artype.ArTypeOuPageParam;
import com.elitesland.yst.production.fin.domain.service.artype.ArTypeOuDomainService;
import com.elitesland.yst.production.fin.infr.dto.artype.ArTypeOuDTO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.application.service.artype
 * @date 2022/4/11 17:04
 */
@Service
@RequiredArgsConstructor
public class ArTypeOuServiceImpl implements ArTypeOuService {

    private final ArTypeOuDomainService arTypeOuDomainService;

    @SysCodeProc
    @Override
    public PagingVO<ArTypeOuVO> page(ArTypeOuPageParam arTypeOuPageParam) {

        PagingVO<ArTypeOuDTO> res = arTypeOuDomainService.page(arTypeOuPageParam);
        return ArTypeOuConvert.INSTANCE.convertPage(res);
    }

    @Override
    public ApiResult<Boolean> addOu(ArTypeOuSaveParam arTypeOuSaveParam) {
        for (ArTypeOuParam arTypeOuParam : arTypeOuSaveParam.getArTypeOuParamList()) {
            ArTypeOu arTypeOu = ArTypeOuConvert.INSTANCE.convert(arTypeOuParam);
            arTypeOu.setArTypeId(arTypeOuSaveParam.getArTypeId());
            arTypeOuDomainService.addOu(arTypeOu);
        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Boolean> cancelOu(List<Long> ids) {
        arTypeOuDomainService.cancelOu(ids);
        return ApiResult.ok();
    }
}
