package com.elitesland.yst.production.fin.application.service.paytype;

import com.elitesland.yst.production.fin.application.convert.paytype.PayTypeOuConvert;
import com.elitesland.yst.production.fin.application.facade.param.paytype.PayTypeOuParam;
import com.elitesland.yst.production.fin.application.facade.vo.paytype.PayTypeOuVO;
import com.elitesland.yst.production.fin.domain.entity.paytype.PayTypeOu;
import com.elitesland.yst.production.fin.domain.param.paytype.PayTypeOuPageParam;
import com.elitesland.yst.production.fin.domain.service.paytype.PayTypeOuDomainService;
import com.elitesland.yst.production.fin.infr.dto.paytype.PayTypeOuDTO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
/**
 * @author zhiyu.he
 * @date 2022/3/16 10:41
 */
@Service
@RequiredArgsConstructor
public class PayTypeOuServiceImpl implements PayTypeOuService {
    private final PayTypeOuDomainService payTypeOuDomainService;

    @SysCodeProc
    @Override
    public PagingVO<PayTypeOuVO> page(PayTypeOuPageParam param) {
        PagingVO<PayTypeOuDTO> page = payTypeOuDomainService.page(param);
        return  PayTypeOuConvert.INSTANCE.convertPage(page);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<List<Long>> cancelOu(List<Long> ids) {
        return ApiResult.ok(payTypeOuDomainService.cancelOu(ids));
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<List<Long>> addOu(PayTypeOuParam param) {
        //转换为实体
        List<PayTypeOu> payTypeOus = PayTypeOuConvert.INSTANCE.paramConvert(param.getPayTypeOuSaveParams());
        //设置实体付款单类型ID
        payTypeOus.forEach(ou->{
            ou.setPayTypeId(param.getPayTypeId());
        });
        return ApiResult.ok(payTypeOuDomainService.addOu(payTypeOus));
    }
}
