package com.elitesland.yst.production.fin.infr.repo.arverrec;

import com.elitesland.yst.production.fin.domain.entity.arverrec.QArVerRecDtlDO;
import com.elitesland.yst.production.fin.domain.param.arverrec.ArVerRecPageParam;
import com.elitesland.yst.production.fin.infr.dto.arverrec.ArVerRecDtlDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/26 13:22
 */
@Component
@RequiredArgsConstructor
public class ArVerRecDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QArVerRecDtlDO qArVerRecDtlDO = QArVerRecDtlDO.arVerRecDtlDO;

    //根据核销方案ID查询是否有核销记录关联数据
    public Boolean queryByScId(Long scId) {
        return jpaQueryFactory.select(qArVerRecDtlDO.id)
                .from(qArVerRecDtlDO)
                .where(qArVerRecDtlDO.schemeId.eq(scId))
                .where(qArVerRecDtlDO.deleteFlag.eq(0))
                .fetchCount() > 0;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qArVerRecDtlDO.id,
                qArVerRecDtlDO.amt,
                qArVerRecDtlDO.buDate,
                qArVerRecDtlDO.currCode,
                qArVerRecDtlDO.currName,
                qArVerRecDtlDO.masId,
                qArVerRecDtlDO.orderId,
                qArVerRecDtlDO.orderName,
                qArVerRecDtlDO.orderNo,
                qArVerRecDtlDO.orderType,
                qArVerRecDtlDO.ouId,
                qArVerRecDtlDO.ouCode,
                qArVerRecDtlDO.ouName,
                qArVerRecDtlDO.custCode,
                qArVerRecDtlDO.custName,
                qArVerRecDtlDO.custId,
                qArVerRecDtlDO.verNo,
                qArVerRecDtlDO.verDate,
                qArVerRecDtlDO.schemeName,
                qArVerRecDtlDO.verifyType,
                qArVerRecDtlDO.schemeNo,
                qArVerRecDtlDO.schemeId,
                qArVerRecDtlDO.remark,
                qArVerRecDtlDO.createTime,
                qArVerRecDtlDO.creator,
                qArVerRecDtlDO.createUserId,
                qArVerRecDtlDO.modifyTime,
                qArVerRecDtlDO.modifyUserId,
                qArVerRecDtlDO.updater)
        ).from(qArVerRecDtlDO);
    }


    public List<ArVerRecDtlDTO> queryDtlByMasIds(Collection<Long> masIds) {
        return select(ArVerRecDtlDTO.class).where(qArVerRecDtlDO.masId.in(masIds).and(qArVerRecDtlDO.deleteFlag.eq(0))).fetch();
    }

    public Long logicDelByIds(Collection<Long> ids) {
        return jpaQueryFactory.update(qArVerRecDtlDO).set(qArVerRecDtlDO.deleteFlag, 1)
                .where(qArVerRecDtlDO.id.in(ids).and(qArVerRecDtlDO.deleteFlag.eq(0))).execute();
    }


    public PagingVO<ArVerRecDtlDTO> page(ArVerRecPageParam pageParam) {
        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotBlank(pageParam.getVerNo())) {
            predicates.add(qArVerRecDtlDO.verNo.like("%" + pageParam.getVerNo() + "%"));
        }
        if (null != pageParam.getOuId()) {
            predicates.add(qArVerRecDtlDO.ouId.eq(pageParam.getOuId()));
        }
        if (null != pageParam.getCustId()) {
            predicates.add(qArVerRecDtlDO.custId.eq(pageParam.getCustId()));
        }
        if (StringUtils.isNotBlank(pageParam.getCustName())) {
            predicates.add(qArVerRecDtlDO.custName.like("%" + pageParam.getCustName() + "%"));
        }
        if (StringUtils.isNotBlank(pageParam.getCurrCode())) {
            predicates.add(qArVerRecDtlDO.currCode.eq(pageParam.getCurrCode()));
        }
        if (StringUtils.isNotBlank(pageParam.getVerifyType())) {
            predicates.add(qArVerRecDtlDO.verifyType.eq(pageParam.getVerifyType()));
        }
        if (null != pageParam.getVerDateStart() && null != pageParam.getVerDateEnd()) {
            predicates.add(qArVerRecDtlDO.verDate.between(pageParam.getVerDateStart(), pageParam.getVerDateEnd()));
        }
        predicates.add(qArVerRecDtlDO.deleteFlag.eq(0));
        JPAQuery<ArVerRecDtlDTO> query = select(ArVerRecDtlDTO.class)
                .where(ExpressionUtils.allOf(predicates));
        pageParam.setPaging(query);
        pageParam.fillOrders(query, qArVerRecDtlDO);
        return PagingVO.<ArVerRecDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

}
