/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.application.service.account;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.application.convert.account.AccountConvert;
import com.elitesland.yst.production.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.yst.production.fin.application.facade.param.account.AccountParam;
import com.elitesland.yst.production.fin.application.facade.vo.account.AccountVO;
import com.elitesland.yst.production.fin.application.service.account.AccountService;
import com.elitesland.yst.production.fin.common.SysNumEnum;
import com.elitesland.yst.production.fin.common.SysNumberGenerator;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.entity.account.AccountDO;
import com.elitesland.yst.production.fin.repo.account.AccountRepo;
import com.elitesland.yst.production.fin.repo.account.AccountRepoProc;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountServiceImpl
implements AccountService {
    private final AccountRepoProc accountRepoProc;
    private final AccountRepo accountRepo;
    private final SysNumberGenerator sysNumberGenerator;

    @Override
    @Transactional
    public Long save(AccountParam accountParam) {
        if (null == accountParam.getState()) {
            accountParam.setState(UdcEnum.FIN_ENABLE_STATE_DISENABLE.getValueCode());
        }
        if (null == accountParam.getId()) {
            String docNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_ACC_NO.getCode());
            accountParam.setAccCode(docNo);
        }
        AccountDO accountDO = AccountConvert.INSTANCE.p2En(accountParam);
        if (null == accountParam.getAccAmt()) {
            accountDO.setAccAmt(BigDecimal.ZERO);
        }
        if (null == accountParam.getAccOccAmt()) {
            accountDO.setAccOccAmt(BigDecimal.ZERO);
        }
        AccountDO res = (AccountDO)((Object)this.accountRepo.save((Object)accountDO));
        return res.getId();
    }

    @Override
    public void existAccName(String accName) {
        Long a = this.accountRepoProc.existAccName(accName);
        if (a > 0L) {
            throw new BusinessException(accName + "\u8d26\u6237\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
    }

    @Override
    public void existAccNameCode(String accNameCode) {
        Long a = this.accountRepoProc.existAccNameCode(accNameCode);
        if (a > 0L) {
            throw new BusinessException(accNameCode + "\u8d26\u6237\u540d\u79f0\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
    }

    @Override
    @SysCodeProc
    public AccountVO get(Long id) {
        AccountVO res = this.accountRepoProc.get(id);
        return res;
    }

    @Override
    @SysCodeProc
    public PagingVO<AccountVO> page(AccountPageParam accountPageParam) {
        PagingVO<AccountVO> res = this.accountRepoProc.page(accountPageParam);
        return res;
    }

    @Override
    @Transactional
    public Long updateState(AccountParam accountParam) {
        if (null == accountParam.getIds()) {
            throw new BusinessException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long res = this.accountRepoProc.updateState(accountParam);
        return res;
    }

    @Override
    public List<AccountVO> queryAccount(List<String> accountCodes, String type, String state) {
        return this.accountRepoProc.queryByAccounts(accountCodes, type, state);
    }

    @Override
    public AccountVO getByCode(String accCode) {
        AccountVO res = this.accountRepoProc.getByCode(accCode);
        return res;
    }

    @Override
    @Transactional
    public Boolean updateAmtByCode(String accCode, BigDecimal accAmt, BigDecimal accOccAmt) {
        Assert.notEmpty((CharSequence)accCode, (String)"accCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AccountParam accountParam = new AccountParam();
        accountParam.setAccCode(accCode);
        accountParam.setAccAmt(accAmt);
        accountParam.setAccOccAmt(accOccAmt);
        if (null != accAmt && null != accOccAmt) {
            return this.accountRepoProc.updateAmtByCode(accountParam);
        }
        if (null != accAmt) {
            return this.accountRepoProc.updateAccAmtByCode(accountParam);
        }
        if (null != accOccAmt) {
            return this.accountRepoProc.updateOccAmtByCode(accountParam);
        }
        return true;
    }

    public AccountServiceImpl(AccountRepoProc accountRepoProc, AccountRepo accountRepo, SysNumberGenerator sysNumberGenerator) {
        this.accountRepoProc = accountRepoProc;
        this.accountRepo = accountRepo;
        this.sysNumberGenerator = sysNumberGenerator;
    }
}

