/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.infr.factory.arverrec;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.domain.param.arverrec.ArVerRecPageParam;
import com.elitesland.yst.production.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.yst.production.fin.infr.dto.arverrec.ArVerRecDtlDTO;
import com.elitesland.yst.production.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.yst.production.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.yst.production.fin.infr.repo.arverrec.ArVerRecDtlRepoProc;
import com.elitesland.yst.production.fin.infr.repo.recorder.RecOrderRepoProc;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ArVerRecFactory {
    private final ArVerRecDtlRepoProc arVerRecDtlRepoProc;
    private final ArOrderRepoProc arOrderRepoProc;
    private final RecOrderRepoProc recOrderRepoProc;

    public PagingVO<ArVerRecDtlDTO> page(ArVerRecPageParam pageParam) {
        List<Long> apIds;
        PagingVO<ArVerRecDtlDTO> page = this.arVerRecDtlRepoProc.page(pageParam);
        List records = page.getRecords();
        List<Long> payIds = records.stream().filter(t -> t.getOrderType().equals("REC")).map(ArVerRecDtlDTO::getOrderId).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(payIds)) {
            Map<Long, RecOrderDTO> recOrderDTOMap = this.recOrderRepoProc.queryByIds(payIds).stream().collect(Collectors.toMap(RecOrderDTO::getId, t -> t));
            records.forEach(t -> {
                if (recOrderDTOMap.containsKey(t.getOrderId())) {
                    t.setTotalAmt(((RecOrderDTO)recOrderDTOMap.get(t.getOrderId())).getTotalAmt());
                    t.setVerState(((RecOrderDTO)recOrderDTOMap.get(t.getOrderId())).getVerState());
                    t.setVerAmt(((RecOrderDTO)recOrderDTOMap.get(t.getOrderId())).getVerAmt());
                }
            });
        }
        if (CollUtil.isNotEmpty(apIds = records.stream().filter(t -> t.getOrderType().equals("AR")).map(ArVerRecDtlDTO::getOrderId).collect(Collectors.toList()))) {
            Map<Long, ArOrderDTO> arOrderDTOMap = this.arOrderRepoProc.queryByIds(apIds).stream().collect(Collectors.toMap(ArOrderDTO::getId, t -> t));
            records.forEach(t -> {
                if (arOrderDTOMap.containsKey(t.getOrderId())) {
                    t.setTotalAmt(((ArOrderDTO)arOrderDTOMap.get(t.getOrderId())).getTotalAmt());
                    t.setVerState(((ArOrderDTO)arOrderDTOMap.get(t.getOrderId())).getVerState());
                    t.setVerAmt(((ArOrderDTO)arOrderDTOMap.get(t.getOrderId())).getVerAmt());
                }
            });
        }
        return page;
    }

    public ArVerRecFactory(ArVerRecDtlRepoProc arVerRecDtlRepoProc, ArOrderRepoProc arOrderRepoProc, RecOrderRepoProc recOrderRepoProc) {
        this.arVerRecDtlRepoProc = arVerRecDtlRepoProc;
        this.arOrderRepoProc = arOrderRepoProc;
        this.recOrderRepoProc = recOrderRepoProc;
    }
}

