/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.infr.repo.arorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.domain.entity.arorder.QArOrderDO;
import com.elitesland.yst.production.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.yst.production.fin.domain.param.arorder.ArOrderParam;
import com.elitesland.yst.production.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.yst.production.fin.infr.dto.common.ArVerDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ArOrderRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QArOrderDO qArOrderDO = QArOrderDO.arOrderDO;

    public PagingVO<ArOrderDTO> page(ArOrderPageParam arOrderPageParam, List<Long> ids) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.checkParam(arOrderPageParam, predicates);
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getCreateMode())) {
            predicates.add((Predicate)this.qArOrderDO.createMode.eq((Object)arOrderPageParam.getCreateMode()));
        }
        if (null != arOrderPageParam.getInitFlag()) {
            predicates.add((Predicate)this.qArOrderDO.initFlag.eq(arOrderPageParam.getInitFlag()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getSourceNoDtl())) {
            if (CollUtil.isNotEmpty(ids)) {
                predicates.add((Predicate)this.qArOrderDO.id.in(ids));
            } else {
                return new PagingVO(0L, new ArrayList());
            }
        }
        this.buildPredicates(arOrderPageParam, predicates);
        predicates.add((Predicate)this.qArOrderDO.deleteFlag.eq((Object)0));
        JPAQuery query = (JPAQuery)this.select(ArOrderDTO.class).where(ExpressionUtils.allOf(predicates));
        arOrderPageParam.setPaging(query);
        arOrderPageParam.fillOrders(query, this.qArOrderDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private void buildPredicates(ArOrderPageParam arOrderPageParam, List<Predicate> predicates) {
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getOrgCode())) {
            predicates.add((Predicate)this.qArOrderDO.orgCode.eq((Object)arOrderPageParam.getOrgCode()));
        }
        if (null != arOrderPageParam.getOrgId()) {
            predicates.add((Predicate)this.qArOrderDO.orgId.eq((Object)arOrderPageParam.getOrgId()));
        }
        if (null != arOrderPageParam.getCustId()) {
            predicates.add((Predicate)this.qArOrderDO.custId.eq((Object)arOrderPageParam.getCustId()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getCustName())) {
            predicates.add((Predicate)this.qArOrderDO.custName.like("%" + arOrderPageParam.getCustName() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getCurrCode())) {
            predicates.add((Predicate)this.qArOrderDO.currCode.eq((Object)arOrderPageParam.getCurrCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getSaleUser())) {
            predicates.add((Predicate)this.qArOrderDO.saleUser.like("%" + arOrderPageParam.getSaleUser() + "%"));
        }
        if (null != arOrderPageParam.getBuId()) {
            predicates.add((Predicate)this.qArOrderDO.buId.eq((Object)arOrderPageParam.getBuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getBuCode())) {
            predicates.add((Predicate)this.qArOrderDO.buCode.eq((Object)arOrderPageParam.getBuCode()));
        }
        if (null != arOrderPageParam.getAuditDateStart() && null != arOrderPageParam.getAuditDateEnd()) {
            predicates.add((Predicate)this.qArOrderDO.auditDate.between((Comparable)arOrderPageParam.getAuditDateStart(), (Comparable)arOrderPageParam.getAuditDateEnd()));
        }
    }

    private void checkParam(ArOrderPageParam arOrderPageParam, List<Predicate> predicates) {
        if (null != arOrderPageParam.getOuId()) {
            predicates.add((Predicate)this.qArOrderDO.ouId.eq((Object)arOrderPageParam.getOuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getCurrCode())) {
            predicates.add((Predicate)this.qArOrderDO.currCode.eq((Object)arOrderPageParam.getCurrCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getCurrName())) {
            predicates.add((Predicate)this.qArOrderDO.currName.eq((Object)arOrderPageParam.getCurrName()));
        }
        if (null != arOrderPageParam.getBuDateStart() && null != arOrderPageParam.getBuDateEnd()) {
            predicates.add((Predicate)this.qArOrderDO.buDate.between((Comparable)arOrderPageParam.getBuDateStart(), (Comparable)arOrderPageParam.getBuDateEnd()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getSourceNo())) {
            predicates.add((Predicate)this.qArOrderDO.sourceNo.like("%" + arOrderPageParam.getSourceNo() + "%"));
        }
        if (null != arOrderPageParam.getArTypeId()) {
            predicates.add((Predicate)this.qArOrderDO.arTypeId.eq((Object)arOrderPageParam.getArTypeId()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getOrderState())) {
            predicates.add((Predicate)this.qArOrderDO.orderState.eq((Object)arOrderPageParam.getOrderState()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getVerState())) {
            predicates.add((Predicate)this.qArOrderDO.verState.eq((Object)arOrderPageParam.getVerState()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getArOrderNo())) {
            predicates.add((Predicate)this.qArOrderDO.arOrderNo.like("%" + arOrderPageParam.getArOrderNo() + "%"));
        }
        if (null != arOrderPageParam.getTotalAmtStart()) {
            predicates.add((Predicate)this.qArOrderDO.totalAmt.goe((Number)arOrderPageParam.getTotalAmtStart()));
        }
        if (null != arOrderPageParam.getTotalAmtEnd()) {
            predicates.add((Predicate)this.qArOrderDO.totalAmt.loe((Number)arOrderPageParam.getTotalAmtEnd()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getOperator())) {
            predicates.add((Predicate)this.qArOrderDO.operator.like("%" + arOrderPageParam.getOperator() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getCreator())) {
            predicates.add((Predicate)this.qArOrderDO.creator.like("%" + arOrderPageParam.getCreator() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getAuditUser())) {
            predicates.add((Predicate)this.qArOrderDO.auditUser.like("%" + arOrderPageParam.getAuditUser() + "%"));
        }
    }

    public List<ArOrderDTO> queryByIds(List<Long> ids) {
        return ((JPAQuery)this.select(ArOrderDTO.class).where((Predicate)this.qArOrderDO.id.in(ids))).fetch();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qArOrderDO.id, this.qArOrderDO.sourceNo, this.qArOrderDO.ouCode, this.qArOrderDO.ouId, this.qArOrderDO.ouName, this.qArOrderDO.arTypeId, this.qArOrderDO.arTypeName, this.qArOrderDO.arTypeCode, this.qArOrderDO.currCode, this.qArOrderDO.currName, this.qArOrderDO.operator, this.qArOrderDO.operUserId, this.qArOrderDO.buType, this.qArOrderDO.totalAmt, this.qArOrderDO.totalCurAmt, this.qArOrderDO.buDate, this.qArOrderDO.auditUserId, this.qArOrderDO.auditUser, this.qArOrderDO.auditDate, this.qArOrderDO.orderState, this.qArOrderDO.exchangeRate, this.qArOrderDO.initFlag, this.qArOrderDO.taxFlag, this.qArOrderDO.buId, this.qArOrderDO.buCode, this.qArOrderDO.buName, this.qArOrderDO.payMentName, this.qArOrderDO.payMentCode, this.qArOrderDO.payMentId, this.qArOrderDO.createTime, this.qArOrderDO.updater, this.qArOrderDO.modifyTime, this.qArOrderDO.exclTaxAmt, this.qArOrderDO.taxAmt, this.qArOrderDO.taxCurAmt, this.qArOrderDO.arOrderNo, this.qArOrderDO.creator, this.qArOrderDO.createMode, this.qArOrderDO.remark, this.qArOrderDO.localCurrCode, this.qArOrderDO.localCurrName, this.qArOrderDO.exclTaxCurAmt, this.qArOrderDO.verState, this.qArOrderDO.verAmt, this.qArOrderDO.orgId, this.qArOrderDO.orgCode, this.qArOrderDO.orgName, this.qArOrderDO.saleUserId, this.qArOrderDO.saleUser, this.qArOrderDO.arOrderType, this.qArOrderDO.custName, this.qArOrderDO.custId, this.qArOrderDO.custCode, this.qArOrderDO.auditDataVersion, this.qArOrderDO.procInstId, this.qArOrderDO.procInstStatus, this.qArOrderDO.docType, this.qArOrderDO.docType2, this.qArOrderDO.docCls, this.qArOrderDO.approvedTime, this.qArOrderDO.submitTime})).from((EntityPath)this.qArOrderDO);
    }

    public ArOrderDTO get(Long id) {
        ArOrderDTO arOrderDTO = (ArOrderDTO)((JPAQuery)this.select(ArOrderDTO.class).where((Predicate)this.qArOrderDO.id.eq((Object)id))).fetchOne();
        return arOrderDTO;
    }

    public Long audit(List<Long> ids, String content, SysUserDTO user) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qArOrderDO).set(this.qArOrderDO.auditDate, (Object)LocalDateTime.now()).set((Path)this.qArOrderDO.auditRejection, (Object)content).set((Path)this.qArOrderDO.auditUser, (Object)user.getUsername()).set(this.qArOrderDO.auditUserId, (Object)user.getId()).where(new Predicate[]{this.qArOrderDO.id.in(ids)}).execute();
        return res;
    }

    public Boolean queryByArTypeId(Long id) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qArOrderDO.id).from((EntityPath)this.qArOrderDO)).where((Predicate)this.qArOrderDO.arTypeId.eq((Object)id))).fetchCount() > 0L;
    }

    public Long del(List<Long> ids) {
        long res = this.jpaQueryFactory.delete((EntityPath)this.qArOrderDO).where(new Predicate[]{this.qArOrderDO.id.in(ids)}).execute();
        return res;
    }

    public ArVerDTO queryVerAmtById(Long id) {
        return (ArVerDTO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ArVerDTO.class, (Expression[])new Expression[]{this.qArOrderDO.id, this.qArOrderDO.totalAmt, this.qArOrderDO.verAmt, this.qArOrderDO.auditDataVersion})).from((EntityPath)this.qArOrderDO)).where((Predicate)this.qArOrderDO.id.eq((Object)id))).fetchOne();
    }

    public long updateVerAmt(ArVerDTO arVerDTO) {
        return this.jpaQueryFactory.update((EntityPath)this.qArOrderDO).set((Path)this.qArOrderDO.verState, (Object)arVerDTO.getVerState()).set(this.qArOrderDO.verAmt, (Object)arVerDTO.getVerAmt()).set(this.qArOrderDO.auditDataVersion, (Object)(arVerDTO.getAuditDataVersion() + 1)).where(new Predicate[]{this.qArOrderDO.id.eq((Object)arVerDTO.getId()).and((Predicate)this.qArOrderDO.totalAmt.goe((Number)arVerDTO.getVerAmt())).and((Predicate)this.qArOrderDO.auditDataVersion.eq((Object)arVerDTO.getAuditDataVersion()))}).execute();
    }

    public List<ArOrderDTO> getArOrderList(ArOrderParam arOrderParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (null != arOrderParam.getOuId()) {
            predicates.add(this.qArOrderDO.ouId.eq((Object)arOrderParam.getOuId()));
        }
        if (arOrderParam.getCustId() != null) {
            predicates.add(this.qArOrderDO.custId.eq((Object)arOrderParam.getCustId()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)arOrderParam.getCurrCode())) {
            predicates.add(this.qArOrderDO.currCode.eq((Object)arOrderParam.getCurrCode()));
        }
        if (null != arOrderParam.getBuDateStart() && null != arOrderParam.getBuDateEnd()) {
            predicates.add(this.qArOrderDO.buDate.between((Comparable)arOrderParam.getBuDateStart(), (Comparable)arOrderParam.getBuDateEnd()));
        }
        predicates.add(this.qArOrderDO.orderState.eq((Object)UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode()));
        List fetch = ((JPAQuery)this.select(ArOrderDTO.class).where(ExpressionUtils.allOf(predicates))).fetch();
        return fetch;
    }

    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qArOrderDO).set(this.qArOrderDO.procInstStatus, (Object)ProcInstStatus.APPROVING).set((Path)this.qArOrderDO.procInstId, (Object)processInfo.getProcInstId()).set(this.qArOrderDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{this.qArOrderDO.id.eq((Object)id)});
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(this.qArOrderDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
        }
        jpaUpdateClause.execute();
    }

    public ArOrderRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

