/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.repo.flow;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.yst.production.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.yst.production.fin.entity.flow.QAccountFlowDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AccountFlowRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QAccountFlowDO qAccountFlowDO = QAccountFlowDO.accountFlowDO;

    public PagingVO<AccountFlowVO> page(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = this.where(accountFlowPageParam);
        JPAQuery query = (JPAQuery)this.select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        accountFlowPageParam.setPaging(query);
        accountFlowPageParam.fillOrders(query, this.qAccountFlowDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public AccountFlowVO selectByAccCode(String accCode) {
        return (AccountFlowVO)((JPAQuery)((JPAQuery)((JPAQuery)this.select(AccountFlowVO.class).where((Predicate)this.qAccountFlowDO.accCode.eq((Object)accCode))).where((Predicate)this.qAccountFlowDO.deleteFlag.eq((Object)0).or((Predicate)this.qAccountFlowDO.deleteFlag.isNull()))).orderBy(this.qAccountFlowDO.createTime.desc())).fetchFirst();
    }

    public List<AccountFlowVO> selectListByParam(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = this.where(accountFlowPageParam);
        JPAQuery query = (JPAQuery)this.select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private List<Predicate> where(AccountFlowPageParam accountFlowPageParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add((Predicate)this.qAccountFlowDO.deleteFlag.eq((Object)0).or((Predicate)this.qAccountFlowDO.deleteFlag.isNull()));
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getIds())) {
            predicates.add((Predicate)this.qAccountFlowDO.id.in(accountFlowPageParam.getIds()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccType())) {
            predicates.add((Predicate)this.qAccountFlowDO.accType.eq((Object)accountFlowPageParam.getAccType()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getAccTypeList())) {
            predicates.add((Predicate)this.qAccountFlowDO.accType.in(accountFlowPageParam.getAccTypeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getDataSource())) {
            predicates.add((Predicate)this.qAccountFlowDO.dataSource.eq((Object)accountFlowPageParam.getDataSource()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getDataSourceList())) {
            predicates.add((Predicate)this.qAccountFlowDO.dataSource.in(accountFlowPageParam.getDataSourceList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getFlowNo())) {
            predicates.add((Predicate)this.qAccountFlowDO.flowNo.like("%" + accountFlowPageParam.getFlowNo() + "%"));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getFlowNoList())) {
            predicates.add((Predicate)this.qAccountFlowDO.flowNo.in(accountFlowPageParam.getFlowNoList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getTransactionType())) {
            predicates.add((Predicate)this.qAccountFlowDO.transactionType.eq((Object)accountFlowPageParam.getTransactionType()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getTransactionTypeList())) {
            predicates.add((Predicate)this.qAccountFlowDO.transactionType.in(accountFlowPageParam.getTransactionTypeList()));
        }
        if (accountFlowPageParam.getAmountFrom() != null) {
            predicates.add((Predicate)this.qAccountFlowDO.amount.goe((Number)accountFlowPageParam.getAmountFrom()));
        }
        if (accountFlowPageParam.getAmountTo() != null) {
            predicates.add((Predicate)this.qAccountFlowDO.amount.loe((Number)accountFlowPageParam.getAmountTo()));
        }
        if (accountFlowPageParam.getTransactionTimeS() != null && accountFlowPageParam.getTransactionTimeE() != null) {
            predicates.add((Predicate)this.qAccountFlowDO.transactionTime.between((Comparable)accountFlowPageParam.getTransactionTimeS(), (Comparable)accountFlowPageParam.getTransactionTimeE()));
        } else {
            if (accountFlowPageParam.getTransactionTimeS() != null) {
                predicates.add((Predicate)this.qAccountFlowDO.transactionTime.goe((Comparable)accountFlowPageParam.getTransactionTimeS()));
            }
            if (accountFlowPageParam.getTransactionTimeE() != null) {
                predicates.add((Predicate)this.qAccountFlowDO.transactionTime.loe((Comparable)accountFlowPageParam.getTransactionTimeE()));
            }
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccKeyword())) {
            predicates.add((Predicate)this.qAccountFlowDO.accCode.like("%" + accountFlowPageParam.getAccKeyword() + "%").or((Predicate)this.qAccountFlowDO.accName.like("%" + accountFlowPageParam.getAccKeyword() + "%")));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccCode())) {
            predicates.add((Predicate)this.qAccountFlowDO.accCode.eq((Object)accountFlowPageParam.getAccCode()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getAccCodeList())) {
            predicates.add((Predicate)this.qAccountFlowDO.accCode.in(accountFlowPageParam.getAccCodeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccName())) {
            predicates.add((Predicate)this.qAccountFlowDO.accName.like("%" + accountFlowPageParam.getAccName() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getSourceNo())) {
            predicates.add((Predicate)this.qAccountFlowDO.sourceNo.like("%" + accountFlowPageParam.getSourceNo() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getSourceNoEq())) {
            predicates.add((Predicate)this.qAccountFlowDO.sourceNo.eq((Object)accountFlowPageParam.getSourceNoEq()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getSourceNoList())) {
            predicates.add((Predicate)this.qAccountFlowDO.sourceNo.in(accountFlowPageParam.getSourceNoList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getSourceDoc())) {
            predicates.add((Predicate)this.qAccountFlowDO.sourceDoc.eq((Object)accountFlowPageParam.getSourceDoc()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getSourceDocList())) {
            predicates.add((Predicate)this.qAccountFlowDO.sourceDoc.in(accountFlowPageParam.getSourceDocList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getSourcePlatform())) {
            predicates.add((Predicate)this.qAccountFlowDO.sourcePlatform.eq((Object)accountFlowPageParam.getSourcePlatform()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccIoType())) {
            predicates.add((Predicate)this.qAccountFlowDO.accIoType.eq((Object)accountFlowPageParam.getAccIoType()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getAccIoTypeList())) {
            predicates.add((Predicate)this.qAccountFlowDO.accIoType.in(accountFlowPageParam.getAccIoTypeList()));
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qAccountFlowDO.id, this.qAccountFlowDO.accType, this.qAccountFlowDO.dataSource, this.qAccountFlowDO.flowNo, this.qAccountFlowDO.transactionType, this.qAccountFlowDO.amount, this.qAccountFlowDO.transactionTime, this.qAccountFlowDO.accCode, this.qAccountFlowDO.accName, this.qAccountFlowDO.accAmt, this.qAccountFlowDO.accOccAmt, this.qAccountFlowDO.sourceNo, this.qAccountFlowDO.sourceDoc, this.qAccountFlowDO.sourcePlatform, this.qAccountFlowDO.accIoType, this.qAccountFlowDO.remark, this.qAccountFlowDO.createTime, this.qAccountFlowDO.createUserId, this.qAccountFlowDO.creator, this.qAccountFlowDO.modifyTime, this.qAccountFlowDO.modifyUserId, this.qAccountFlowDO.updater, this.qAccountFlowDO.deleteFlag})).from((EntityPath)this.qAccountFlowDO);
    }

    public PagingVO<AccountFlowVO> dealerPage(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = this.where(accountFlowPageParam);
        JPAQuery query = (JPAQuery)this.dealerSelect(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        accountFlowPageParam.setPaging(query);
        accountFlowPageParam.fillOrders(query, this.qAccountFlowDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private <T> JPAQuery<T> dealerSelect(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qAccountFlowDO.id, this.qAccountFlowDO.flowNo, this.qAccountFlowDO.transactionType, this.qAccountFlowDO.amount, this.qAccountFlowDO.transactionTime, this.qAccountFlowDO.accCode, this.qAccountFlowDO.accName, this.qAccountFlowDO.sourceNo, this.qAccountFlowDO.sourceDoc})).from((EntityPath)this.qAccountFlowDO);
    }

    public List<AccountFlowVO> dealerSelectAmt(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = this.where(accountFlowPageParam);
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccountFlowVO.class, (Expression[])new Expression[]{this.qAccountFlowDO.id, this.qAccountFlowDO.amount})).from((EntityPath)this.qAccountFlowDO);
        jpaQuery.where(ExpressionUtils.allOf(where));
        return jpaQuery.fetch();
    }

    public AccountFlowRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

