package com.elitesland.yst.production.fin.application.service.aporder;

import com.elitesland.yst.production.fin.application.convert.aporder.ApOrderDtlConvert;
import com.elitesland.yst.production.fin.application.facade.vo.aporder.ApOrderDtlVO;
import com.elitesland.yst.production.fin.domain.param.aporder.ApOrderDtlPageParam;
import com.elitesland.yst.production.fin.domain.service.aporder.ApOrderDtlDomainService;
import com.elitesland.yst.production.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.application.service.aporder
 * @date 2022/3/17 13:16
 */
@Service
@RequiredArgsConstructor
public class ApOrderDtlServiceImpl implements ApOrderDtlService {

    private final ApOrderDtlDomainService apOrderDtlDomainService;

    @SysCodeProc
    @Override
    public PagingVO<ApOrderDtlVO> page(ApOrderDtlPageParam apOrderDtlPageParam) {
        PagingVO<ApOrderDtlDTO> page = apOrderDtlDomainService.page(apOrderDtlPageParam);
        PagingVO<ApOrderDtlVO> res = ApOrderDtlConvert.INSTANCE.convertPage(page);
        return res;
    }
}
