package com.elitesland.yst.production.fin.application.service.cgorder;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.application.facade.param.cgorder.CgOrderPageParam;
import com.elitesland.yst.production.fin.application.facade.param.cgorder.CgOrderParam;
import com.elitesland.yst.production.fin.application.facade.vo.cgorder.CgOrderVO;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/17 14:35
 */
public interface CgOrderService {

    PagingVO<CgOrderVO> page(CgOrderPageParam cgOrderPageParam);

    CgOrderVO getOne(Long id);

    //void export(CgOrderPageParam cgOrderPageParam, HttpServletResponse response);

    List<Long> approve(List<Long> ids);

    List<Long> reject(CgOrderParam cgOrderParam);

    List<Long> cancel(List<Long> ids);

    Long returnCg(CgOrderParam cgOrderParam);

    Long save(CgOrderParam cgOrderParam);

    //根据单据类型获取充值类型
    String getCgType(String type);

    //根据充值类型获取单据类型
    String getType(String type);

    List<Long> delete(List<Long> ids);

    /**
     * 已审核的保证金余额查询  入参 userId
     * @param cgOrderParam
     * @return
     */
    BigDecimal queryByUserId(CgOrderParam cgOrderParam);

}
