package com.elitesland.yst.production.fin.application.facade.param.aporder;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.application.facade.param.aporder
 * @date 2022/3/22 14:31
 */
@Data
public class ApOrderDtlGroupSaveParam implements Serializable {

    private static final long serialVersionUID = 8613666470359013969L;
    private Long id;

    @ApiModelProperty(value = "总单ID")
    private Long masId;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "小类编码")
    private String smallCateCode;

    @ApiModelProperty(value = "小类名称")
    private String smallCateName;

    @ApiModelProperty(value = "数量")
    private BigDecimal qty;

    @ApiModelProperty(value = "含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty(value = "含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty(value = "不含税总金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty(value = "不含税总金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmt;

    @ApiModelProperty(value = "税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty(value = "费用部门ID")
    private Long buId;

    @ApiModelProperty(value = "费用部门")
    private String buName;

    @ApiModelProperty(value = "费用类型")
    private String expensesType;

    @ApiModelProperty(value = "备注")
    private String remark;

}
