package com.elitesland.yst.production.fin.application.facade.param.arverrec;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2022/4/27 9:28
 */
@Data
public class ArVerRecDtlSaveParam implements Serializable {
    private static final long serialVersionUID = 6955011277010629703L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("总单ID")
    private Long masId;

    @ApiModelProperty("核销编号")
    private String verNo;

    @ApiModelProperty("核销日期")
    private LocalDateTime verDate;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("单据名称[应收单:收款单]")
    private String orderName;

    @ApiModelProperty("单据编号[应收单号:收款单号]")
    private String orderNo;

    @ApiModelProperty("单据类型[AR:REC]")
    private String orderType;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("单据ID[应收单ID:收款单ID]")
    private Long orderId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("业务日期")
    private LocalDateTime buDate;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本次核销金额")
    private BigDecimal amt;

    @ApiModelProperty("核销方式")
    private String verifyType;

    @ApiModelProperty("核销方案编号")
    private String schemeNo;

    @ApiModelProperty("核销方案名称")
    private String schemeName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("核销方案ID")
    private Long schemeId;

}
