package com.elitesland.yst.production.fin.application.service.account;


import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.fin.application.convert.account.AccountConvert;
import com.elitesland.yst.production.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.yst.production.fin.application.facade.param.account.AccountParam;
import com.elitesland.yst.production.fin.application.facade.vo.account.AccountVO;
import com.elitesland.yst.production.fin.common.SysNumEnum;
import com.elitesland.yst.production.fin.common.SysNumberGenerator;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.entity.account.AccountDO;
import com.elitesland.yst.production.fin.repo.account.AccountRepo;
import com.elitesland.yst.production.fin.repo.account.AccountRepoProc;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.application.service.account
 * @date 2023/2/16 09:02
 */
@Service
@RequiredArgsConstructor
public class AccountServiceImpl implements AccountService {

    private final AccountRepoProc accountRepoProc;
    private final AccountRepo accountRepo;

    private final SysNumberGenerator sysNumberGenerator;

    @Override
    @Transactional
    public Long save(AccountParam accountParam) {

        if (null == accountParam.getState()) {
            accountParam.setState(UdcEnum.FIN_ENABLE_STATE_DISENABLE.getValueCode());
        }
        // 账户编码生成
        if (null == (accountParam.getId())) {
            String docNo = sysNumberGenerator.generate(SysNumEnum.FIN_ACC_NO.getCode());
            accountParam.setAccCode(docNo);
        }
        AccountDO accountDO = AccountConvert.INSTANCE.p2En(accountParam);
        // 初始化默认值
        if (null == accountParam.getAccAmt()) {
            accountDO.setAccAmt(BigDecimal.ZERO);
        }
        if (null == accountParam.getAccOccAmt()) {
            accountDO.setAccOccAmt(BigDecimal.ZERO);
        }
        AccountDO res = accountRepo.save(accountDO);
        return res.getId();
    }

    @Override
    public void existAccName(String accName) {
        Long a = accountRepoProc.existAccName(accName);
        if (a > 0) {
            throw new BusinessException(accName + "账户名称已经存在");
        }
    }

    @Override
    public void existAccNameCode(String accNameCode) {
        Long a = accountRepoProc.existAccNameCode(accNameCode);
        if (a > 0) {
            throw new BusinessException(accNameCode + "账户名称编码已经存在");
        }
    }

    @SysCodeProc
    @Override
    public AccountVO get(Long id) {
        AccountVO res = accountRepoProc.get(id);
        return res;
    }

    @SysCodeProc
    @Override
    public PagingVO<AccountVO> page(AccountPageParam accountPageParam) {
        PagingVO<AccountVO> res = accountRepoProc.page(accountPageParam);
        return res;
    }

    @Override
    @Transactional
    public Long updateState(AccountParam accountParam) {
        if (null == accountParam.getIds()) {
            throw new BusinessException("id不能为空");
        }
        Long res = accountRepoProc.updateState(accountParam);
        return res;
    }

    @Override
    public List<AccountVO> queryAccount(List<String> accountCodes, String type, String state) {
        return accountRepoProc.queryByAccounts(accountCodes, type, state);
    }

    @Override
    public AccountVO getByCode(String accCode) {
        AccountVO res = accountRepoProc.getByCode(accCode);
        return res;
    }

    @Override
    @Transactional
    public Boolean updateAmtByCode(String accCode, BigDecimal accAmt, BigDecimal accOccAmt) {
        Assert.notEmpty(accCode, "accCode不能为空");
        AccountParam accountParam = new AccountParam();
        accountParam.setAccCode(accCode);
        accountParam.setAccAmt(accAmt);
        accountParam.setAccOccAmt(accOccAmt);
        if (null != accAmt && null != accOccAmt) {
            return accountRepoProc.updateAmtByCode(accountParam);
        }
        if (null != accAmt) {
            return accountRepoProc.updateAccAmtByCode(accountParam);
        }
        if (null != accOccAmt) {
            return accountRepoProc.updateOccAmtByCode(accountParam);
        }
        return true;

    }
}
