package com.elitesland.yst.production.fin.application.service.picturefile;

import com.elitesland.yst.production.fin.application.facade.vo.picturefile.PictureFileVO;
import com.elitesland.yst.production.fin.entity.picturefile.PictureFileDO;
import com.elitesland.yst.production.fin.repo.picturefile.PictureFileRepo;
import com.elitesland.yst.production.fin.repo.picturefile.PictureFileRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/21 19:38
 */
@Service
public class PictureFileServiceImpl implements PictureFileService {

    @Autowired
    private  PictureFileRepoProc pictureFileRepoProc;
    @Autowired
    private  PictureFileRepo pictureFileRepo;

    @Override
    public List<PictureFileVO> queryBySourceIds(List<Long> sourceIds) {
        return pictureFileRepoProc.queryBySourceIds(sourceIds);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void deleteBySourceId(List<Long> sourceIds) {
        pictureFileRepoProc.deleteBySourceId(sourceIds);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<PictureFileDO> saveAll(List<PictureFileDO> saveDos) {
        return pictureFileRepo.saveAll(saveDos);
    }

    @Override
    public List<PictureFileVO> queryBySourceIdsAndType(List<Long> sourceIds, String sourceType) {
        return pictureFileRepoProc.queryBySourceIdsAndType(sourceIds,sourceType);
    }

    @Override
    public PictureFileVO queryByCodeAndType(String code, String sourceType) {
        return pictureFileRepoProc.queryByCodeAndType(code,sourceType);
    }
}
