package com.elitesland.yst.production.fin.application.service.rectype;

import com.elitesland.yst.production.fin.application.convert.rectype.RecTypeOuConvert;
import com.elitesland.yst.production.fin.application.facade.param.rectype.RecTypeOuParam;
import com.elitesland.yst.production.fin.application.facade.vo.rectype.RecTypeOuVO;
import com.elitesland.yst.production.fin.domain.entity.rectype.RecTypeOu;
import com.elitesland.yst.production.fin.domain.param.rectype.RecTypeOuPageParam;
import com.elitesland.yst.production.fin.domain.service.rectype.RecTypeOuDomainService;
import com.elitesland.yst.production.fin.infr.dto.rectype.RecTypeOuDTO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/11 13:42
 */
@Service
@RequiredArgsConstructor
public class RecTypeOuServiceImpl implements RecTypeOuService {

    private final RecTypeOuDomainService recTypeDomainService;

    @SysCodeProc
    @Override
    public PagingVO<RecTypeOuVO> page(RecTypeOuPageParam param) {
        PagingVO<RecTypeOuDTO> page = recTypeDomainService.page(param);
        PagingVO<RecTypeOuVO> recTypeOuVOPagingVO = RecTypeOuConvert.INSTANCE.convertPage(page);
        return recTypeOuVOPagingVO;
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<List<Long>> cancelOu(List<Long> ids) {
        return ApiResult.ok(recTypeDomainService.cancelOu(ids));
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<List<Long>> addOu(RecTypeOuParam param) {
        //转换为实体
        List<RecTypeOu> recTypeOus = RecTypeOuConvert.INSTANCE.paramConvert(param.getRecTypeOuSaveParams());
        //设置实体付款单类型ID
        recTypeOus.forEach(ou->{
            ou.setRecTypeId(param.getRecTypeId());
        });
        return ApiResult.ok(recTypeDomainService.addOu(recTypeOus));
    }
}
