package com.elitesland.yst.production.fin.application.web.account;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.yst.production.fin.application.facade.param.account.AccountParam;
import com.elitesland.yst.production.fin.application.facade.vo.account.AccountVO;
import com.elitesland.yst.production.fin.application.service.account.AccountService;
import com.elitesland.yst.production.fin.common.UdcEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.application.web.account
 * @date 2023/2/15 18:23
 */
@RestController
@RequestMapping("/fin/account")
@RequiredArgsConstructor
@Api(value = "账户", tags = {"账户"})
public class AccountController {

    private final AccountService accountService;

    @PostMapping("save")
    @ApiOperation("新增/修改账户信息")
    public ApiResult<Long> page(@RequestBody AccountParam accountParam) {

        if (StringUtils.isBlank(accountParam.getAccName())) {
            throw new BusinessException("账户名称不能为空");
        }
        // 账户名称不能重复
        if (null == accountParam.getId()) {
            accountService.existAccName(accountParam.getAccName());
        } else {
            // 修改
            AccountVO accountVO = accountService.get(accountParam.getId());
            String oldAccName = accountVO.getAccName();
            // 如果修改了名称，校验是否存在
            if (!oldAccName.equals(accountParam.getAccName())) {
                accountService.existAccName(accountParam.getAccName());
            }
        }
        Long res = accountService.save(accountParam);
        return ApiResult.ok(res);
    }

    @PostMapping("enable")
    @ApiOperation("启用账户信息")
    public ApiResult<Long> enable(@RequestBody List<Long> ids) {
        AccountParam accountParam = new AccountParam();
        accountParam.setIds(ids);
        accountParam.setState(UdcEnum.FIN_ENABLE_STATE_ENABLE.getValueCode());
        Long res = accountService.updateState(accountParam);
        return ApiResult.ok(res);
    }

    @PostMapping("disEnable")
    @ApiOperation("禁用账户信息")
    public ApiResult<Long> disEnable(@RequestBody List<Long> ids) {
        AccountParam accountParam = new AccountParam();
        accountParam.setIds(ids);
        accountParam.setState(UdcEnum.FIN_ENABLE_STATE_DISENABLE.getValueCode());
        Long res = accountService.updateState(accountParam);
        return ApiResult.ok(res);
    }

    @GetMapping("get")
    @ApiOperation("账户列表详情")
    public ApiResult<AccountVO> get(Long id) {
        AccountVO res = accountService.get(id);
        return ApiResult.ok(res);
    }

    @PostMapping("page")
    @ApiOperation("账户列表查询")
    public ApiResult<PagingVO<AccountVO>> page(@RequestBody AccountPageParam accountPageParam) {
        PagingVO<AccountVO> res = accountService.page(accountPageParam);
        return ApiResult.ok(res);
    }

    @ApiOperation("根据编码查询账户")
    @GetMapping("getCode")
    public ApiResult<AccountVO> getByCode(String accCode) {
        AccountVO res = accountService.getByCode(accCode);
        return ApiResult.ok(res);
    }

}
