package com.elitesland.yst.production.fin.application.web.adjusttoorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.application.facade.param.adjustorder.AdjustOrderParam;
import com.elitesland.yst.production.fin.application.facade.param.adjusttoorder.AdjustToOrderPageParam;
import com.elitesland.yst.production.fin.application.facade.param.adjusttoorder.AdjustToOrderParam;
import com.elitesland.yst.production.fin.application.facade.vo.adjusttoorder.AdjustToOrderVO;
import com.elitesland.yst.production.fin.application.service.adjusttoorder.AdjustToOrderService;
import com.elitesland.yst.production.fin.common.UdcEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/3/3 17:13
 */
@RestController
@RequestMapping("/fin/adjustTo")
@RequiredArgsConstructor
@Api(value = "调剂单", tags = {"调剂单"})
public class AdjustOrderToController {
    private final AdjustToOrderService adjustToOrderService;

    @PostMapping("/save")
    @ApiOperation("新增调剂单")
    public ApiResult<Long> save(@RequestBody AdjustToOrderParam adjustOrderParam) {
        return ApiResult.ok(adjustToOrderService.save(adjustOrderParam));
    }

    @PostMapping("/update")
    @ApiOperation("修改调剂单")
    public ApiResult<Long> update(@RequestBody AdjustToOrderParam adjustOrderParam) {
        return ApiResult.ok(adjustToOrderService.update(adjustOrderParam));
    }

    @PostMapping("/submit")
    @ApiOperation("提交调剂单")
    public ApiResult<Long> submit(@RequestBody AdjustToOrderParam adjustOrderParam) {
        adjustOrderParam.setState(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode());
        return ApiResult.ok(adjustToOrderService.update(adjustOrderParam));
    }

    @PostMapping("/page")
    @ApiOperation("分页查询调剂单")
    public ApiResult<PagingVO<AdjustToOrderVO>> page(@RequestBody AdjustToOrderPageParam adjustOrderPageParam) {
        return ApiResult.ok(adjustToOrderService.page(adjustOrderPageParam));
    }

    @GetMapping("/getOne/{id}")
    @ApiOperation("调剂单详情")
    public ApiResult<AdjustToOrderVO> getOne(@PathVariable("id") Long id) {
        return ApiResult.ok(adjustToOrderService.getOne(id));
    }

    @PostMapping("/approve")
    @ApiOperation("批量审批调剂单")
    public ApiResult<List<Long>> approve(@RequestBody List<Long> ids) {
        return ApiResult.ok(adjustToOrderService.approve(ids));
    }

    @PostMapping("/reject")
    @ApiOperation("审批拒绝调剂单")
    public ApiResult<List<Long>> reject(@RequestBody AdjustToOrderParam adjustOrderParam) {
        return ApiResult.ok(adjustToOrderService.reject(adjustOrderParam));
    }
}
