package com.elitesland.yst.production.fin.application.web.apverrec;

import com.elitesland.yst.production.fin.application.facade.param.apverrec.ApVerRecParam;
import com.elitesland.yst.production.fin.application.facade.vo.apverrec.ApVerRecDtlVO;
import com.elitesland.yst.production.fin.application.service.apverrec.ApVerRecService;
import com.elitesland.yst.production.fin.domain.param.apverrec.ApVerRecPageParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author Jason.zhao
 * @date 2022/4/24 9:27
 */
@RestController
@RequestMapping("/fin/apVerRec")
@RequiredArgsConstructor
@Api(value = "应付核销管理", tags = {"应付核销管理"})
public class ApVerRecController {

    private final ApVerRecService apVerRecService;

    @PostMapping("confirm")
    @ApiOperation("确定")
    public ApiResult<String> confirm(@RequestBody ApVerRecParam param) {
        apVerRecService.confirm(param);
        return ApiResult.ok("生成核销记录成功");
    }

    @PostMapping("cancel")
    @ApiOperation("取消核销")
    public ApiResult<String> cancel(@RequestBody List<Long> masIds) {
        apVerRecService.cancel(masIds);
        return ApiResult.ok("取消核销记录成功");
    }

    @PostMapping("page")
    @ApiOperation("查询")
    public ApiResult<PagingVO<ApVerRecDtlVO>> page(@RequestBody ApVerRecPageParam pageParam) {
        PagingVO<ApVerRecDtlVO> page = apVerRecService.page(pageParam);
        return ApiResult.ok(page);
    }

}
