package com.elitesland.yst.production.fin.domain.service.apverconfig;

import com.elitesland.yst.production.fin.infr.dto.apverconfig.ApVerConfigDtlDTO;
import com.elitesland.yst.production.fin.infr.repo.apverconfig.ApVerConfigDtlRepo;
import com.elitesland.yst.production.fin.infr.repo.apverconfig.ApVerConfigDtlRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/6 17:18
 */
@Service
@RequiredArgsConstructor
public class ApVerConfigDtlDomainServiceImpl implements ApVerConfigDtlDomainService {

    private final ApVerConfigDtlRepo apVerConfigDtlRepo;

    private final ApVerConfigDtlRepoProc apVerConfigDtlRepoProc;

    @Override
    public List<ApVerConfigDtlDTO> queryDtl() {
        return apVerConfigDtlRepoProc.queryNoMasId();
    }

    @Override
    public List<ApVerConfigDtlDTO> queryByMasId(Long masId) {
        return apVerConfigDtlRepoProc.queryByMasId(masId);
    }
}
