package com.elitesland.yst.production.fin.domain.service.arverrec;
import com.elitesland.yst.production.fin.domain.entity.arverrec.ArVerRecDtl;
import com.elitesland.yst.production.fin.infr.dto.arverrec.ArVerRecDtlDTO;

import java.util.Collection;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/26 13:39
 */
public interface ArVerRecDomainService {

    /**
     * 根据核销方案ID查询是否有关联核销记录
     * @param scId 核销方案ID
     * @return
     */
    Boolean queryByScId(Long scId);

    /**
     * 保存应收核销记录
     * @param arVerRecDtls
     * @return
     */
    Long save(List<ArVerRecDtl> arVerRecDtls);


    /**
     * 按总单ID查询应收核销明细
     * @param masIds 应收核销总单ID
     * @return
     */
    List<ArVerRecDtlDTO> queryDtlByMasIds(Collection<Long> masIds);

    /**
     * 逻辑删除应收核销明细
     * @param ids 明细ids
     * @return
     */
    Long logicDelDtlByIds(Collection<Long> ids);

    /**
     * 逻辑删除应收核销
     * @param ids 单据ids
     * @param userName 当前登陆人名称
     * @param userId 当前登陆人ID
     * @return
     */
    Long logicDelByIds(Collection<Long> ids,String userName,Long userId);
}
