package com.elitesland.yst.production.fin.infr.repo.aporder;

import com.elitesland.yst.production.fin.domain.entity.aporder.ApOrderDtlDO;
import com.elitesland.yst.production.fin.domain.entity.aporder.QApOrderDtlDO;
import com.elitesland.yst.production.fin.domain.param.aporder.ApOrderDtlPageParam;
import com.elitesland.yst.production.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.infr.repo.aporder
 * @date 2022/3/16 10:41
 */
@Component
@RequiredArgsConstructor
public class ApOrderDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QApOrderDtlDO qApOrderDtlDO = QApOrderDtlDO.apOrderDtlDO;

    public PagingVO<ApOrderDtlDTO> page(ApOrderDtlPageParam apOrderDtlPageParam) {

        List<Predicate> predicates = new ArrayList<>();
        // 总单Id
        if (null != apOrderDtlPageParam.getMasId()) {
            predicates.add(qApOrderDtlDO.masId.eq(apOrderDtlPageParam.getMasId()));
        }
        JPAQuery<ApOrderDtlDTO> query = select(ApOrderDtlDTO.class)
                .where(ExpressionUtils.allOf(predicates));
        apOrderDtlPageParam.setPaging(query);
        apOrderDtlPageParam.fillOrders(query, qApOrderDtlDO);

        return PagingVO.<ApOrderDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qApOrderDtlDO.id,
                qApOrderDtlDO.sourceNo,
                qApOrderDtlDO.masId,
                qApOrderDtlDO.sourceLine,
                qApOrderDtlDO.itemId,
                qApOrderDtlDO.itemCode,
                qApOrderDtlDO.itemName,
                qApOrderDtlDO.itemType,
                qApOrderDtlDO.smallCateCode,
                qApOrderDtlDO.smallCateName,
                qApOrderDtlDO.uom,
                qApOrderDtlDO.uomName,
                qApOrderDtlDO.qty,
                qApOrderDtlDO.exclTaxPrice,
                qApOrderDtlDO.price,
                qApOrderDtlDO.taxRate,
                qApOrderDtlDO.totalAmt,
                qApOrderDtlDO.exclTaxAmt,
                qApOrderDtlDO.taxAmt,
                qApOrderDtlDO.totalCurAmt,
                qApOrderDtlDO.exclTaxCurAmt,
                qApOrderDtlDO.taxCurAmt,
                qApOrderDtlDO.remark
        )).from(qApOrderDtlDO);
    }


    public List<Long> findBySourceId(String sourceId) {
        List<Long> res = jpaQueryFactory.select(qApOrderDtlDO.masId)
                .from(qApOrderDtlDO)
                .where(qApOrderDtlDO.sourceNo.like("%" + sourceId + "%"))
                .where(qApOrderDtlDO.deleteFlag.eq(0))
                .fetch();

        return res;
    }

    public List<BigDecimal> countByMasId(Long id) {
        return jpaQueryFactory.select(qApOrderDtlDO.qty)
                .from(qApOrderDtlDO)
                .where(qApOrderDtlDO.masId.eq(id))
                .where(qApOrderDtlDO.deleteFlag.eq(0))
                .fetch();
    }

    public Long del(List<Long> ids) {
        long res = jpaQueryFactory.update(qApOrderDtlDO)
                .set(qApOrderDtlDO.deleteFlag, 1)
                .where(qApOrderDtlDO.masId.in(ids))
                .execute();
        return res;
    }

    public void delByMasId(List<Long> id) {
        jpaQueryFactory.delete(qApOrderDtlDO)
                .where(qApOrderDtlDO.masId.in(id))
                .execute();
    }

    public List<ApOrderDtlDTO> listByMisId(Long masId) {

        List<ApOrderDtlDTO> res = select(ApOrderDtlDTO.class)
                .where(qApOrderDtlDO.masId.eq(masId))
                .where(qApOrderDtlDO.deleteFlag.eq(0))
                .fetch();
        return res;
    }
}
