package com.elitesland.yst.production.fin.infr.repo.paytype;


import org.apache.commons.lang3.StringUtils;
import com.elitesland.yst.production.fin.domain.entity.paytype.QPayTypeOuDO;
import com.elitesland.yst.production.fin.domain.param.paytype.PayTypeOuPageParam;
import com.elitesland.yst.production.fin.infr.dto.paytype.PayTypeOuDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;


import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date ${DATE} ${TIME}
 */
@Component
@RequiredArgsConstructor
public class PayTypeOuRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QPayTypeOuDO qPayTypeOuDO = QPayTypeOuDO.payTypeOuDO;

    public List<PayTypeOuDTO> queryByPayTypeIds(List<Long> payTypeIds) {
        return select(PayTypeOuDTO.class)
                .where(qPayTypeOuDO.payTypeId.in(payTypeIds))
                .fetch();
    }

    public void deleteByIds(List<Long> ids) {
        jpaQueryFactory.delete(qPayTypeOuDO)
                .where(qPayTypeOuDO.id.in(ids))
                .execute();
    }

    public List<Long> queryByOuId(Long ouId) {
        return jpaQueryFactory.select(qPayTypeOuDO.payTypeId)
                .from(qPayTypeOuDO)
                .where(qPayTypeOuDO.ouId.eq(ouId))
                .fetch();
    }

    public PagingVO<PayTypeOuDTO> page(PayTypeOuPageParam payTypeOuParam) {
        // 条件拼接
        List<Predicate> predicates = new ArrayList<>();
        if (payTypeOuParam.getPayTypeId() != null) {
            predicates.add(qPayTypeOuDO.payTypeId.eq(payTypeOuParam.getPayTypeId()));
        }
        if (!StringUtils.isEmpty(payTypeOuParam.getOuNameOrCode())) {
            predicates.add(qPayTypeOuDO.ouName.like("%" + payTypeOuParam.getOuNameOrCode() + "%").or(qPayTypeOuDO.ouCode.like("%" + payTypeOuParam.getOuNameOrCode() + "%")));
        }
        JPAQuery<PayTypeOuDTO> query = select(PayTypeOuDTO.class).where(ExpressionUtils.allOf(predicates));
        payTypeOuParam.setPaging(query);
        payTypeOuParam.fillOrders(query, qPayTypeOuDO);
        return PagingVO.<PayTypeOuDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qPayTypeOuDO.id,
                qPayTypeOuDO.payTypeId,
                qPayTypeOuDO.ouCode,
                qPayTypeOuDO.ouId,
                qPayTypeOuDO.ouName,
                qPayTypeOuDO.ouType)
        ).from(qPayTypeOuDO);
    }
}
