package com.elitesland.yst.production.fin.provider.payorder;

import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.production.fin.Application;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.yst.production.fin.application.convert.payorder.PayOrderConvert;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.domain.entity.payorder.PayOrder;
import com.elitesland.yst.production.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.yst.production.fin.param.payorder.PayOrderRpcParam;
import com.elitesland.yst.production.fin.service.aporder.ApOrderRpcService;
import com.elitesland.yst.production.fin.service.payorder.PayOrderRpcService;
import com.elitescloud.boot.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.provider.payorder
 * @date 2022/5/18 13:16
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + PayOrderRpcService.PATH)
public class PayOrderRpcServiceImpl implements PayOrderRpcService {

    public final PayOrderDomainService payOrderDomainService;

    @Override
    public Long save(PayOrderRpcParam payOrderRpcParam) {
        if (CharSequenceUtil.isBlank(payOrderRpcParam.getCreateMode())) {
            throw new BusinessException("来源单据 createMode不能为空");
        }
        PayOrder payOrder = PayOrderConvert.INSTANCE.convertRpc(payOrderRpcParam);
        payOrder.setOrderState(UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode());
        Long resId = payOrderDomainService.save(payOrder);
        return resId;
    }
}
