package com.elitesland.yst.production.fin.provider.saleinv;

import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.production.fin.Application;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.yst.production.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.yst.production.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.yst.production.fin.param.saleinv.SaleInvRpcParam;
import com.elitesland.yst.production.fin.service.payorder.PayOrderRpcService;
import com.elitesland.yst.production.fin.service.saleinv.SaleInvRpcService;
import com.elitescloud.boot.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.provider.saleinv
 * @date 2022/5/23 14:08
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + SaleInvRpcService.PATH)
public class SaleInvRpcServiceImpl implements SaleInvRpcService {

    public final SaleInvDomainService saleInvDomainService;

    @Override
    public Long save(SaleInvRpcParam saleInvRpcParam) {
        if (CharSequenceUtil.isBlank(saleInvRpcParam.getCreateMode())) {
            throw new BusinessException("来源单据 createMode不能为空");
        }
        SaleInv saleInv = SaleInvConvert.INSTANCE.convertRpc(saleInvRpcParam);
        saleInv.setOrderState(UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode());
        Long resId = saleInvDomainService.save(saleInv);
        return resId;
    }
}
