/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.application.service.flow;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.yst.production.fin.application.convert.flow.AccountFlowConvert;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowAccAmtParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.yst.production.fin.application.facade.vo.account.AccountVO;
import com.elitesland.yst.production.fin.application.facade.vo.flow.AccountFlowAccAmtVO;
import com.elitesland.yst.production.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.yst.production.fin.application.service.account.AccountService;
import com.elitesland.yst.production.fin.application.service.flow.AccountFlowCommonService;
import com.elitesland.yst.production.fin.common.FinConstant;
import com.elitesland.yst.production.fin.common.SysNumEnum;
import com.elitesland.yst.production.fin.common.SysNumberGenerator;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.entity.flow.AccountFlowDO;
import com.elitesland.yst.production.fin.repo.flow.AccountFlowRepo;
import com.elitesland.yst.production.fin.repo.flow.AccountFlowRepoProc;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountFlowCommonServiceImpl
implements AccountFlowCommonService {
    @Autowired
    private AccountFlowRepo accountFlowRepo;
    @Autowired
    private AccountFlowRepoProc accountFlowRepoProc;
    @Autowired
    private AccountService accountService;
    @Autowired
    private SysNumberGenerator sysNumberGenerator;

    @Override
    @SysCodeProc
    public Optional<AccountFlowVO> selectByAccCode(String accCode) {
        if (StringUtils.isEmpty((CharSequence)accCode)) {
            return Optional.empty();
        }
        AccountFlowVO accountFlowVO = this.accountFlowRepoProc.selectByAccCode(accCode);
        return Optional.ofNullable(accountFlowVO);
    }

    @Override
    public AccountFlowAccAmtVO selectPreviousData(String accCode) {
        boolean previousFlag = true;
        boolean accFlag = true;
        AccountFlowAccAmtVO accountFlowAccAmtVO = new AccountFlowAccAmtVO();
        Optional<AccountFlowVO> accountFlowVOOptional = this.selectByAccCode(accCode);
        if (accountFlowVOOptional.isPresent()) {
            previousFlag = false;
            accFlag = false;
            AccountFlowVO accountFlowVO = accountFlowVOOptional.get();
            accountFlowAccAmtVO.setAccAmt(accountFlowVO.getAccAmt());
            accountFlowAccAmtVO.setAccOccAmt(accountFlowVO.getAccOccAmt());
        } else {
            previousFlag = false;
            accFlag = false;
            AccountVO accountVO = this.selectAccountByAccCode(accCode);
            accountFlowAccAmtVO.setAccAmt(accountVO.getAccAmt());
            accountFlowAccAmtVO.setAccOccAmt(accountVO.getAccOccAmt());
        }
        if (previousFlag) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4e0a\u4e00\u6761\u6d41\u6c34\u91d1\u989d\u6570\u636e!");
        }
        if (accFlag) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u91d1\u989d\u6570\u636e!");
        }
        return accountFlowAccAmtVO;
    }

    @Override
    public AccountVO selectAccountByAccCode(String accCode) {
        if (StringUtils.isBlank((CharSequence)accCode)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u6237\u7f16\u7801\u4e3a\u7a7a!");
        }
        AccountVO accountVO = this.accountService.getByCode(accCode);
        if (Objects.isNull(accountVO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f!");
        }
        return accountVO;
    }

    @Override
    public AccountFlowAccAmtParam accAmtParamPassValue(BigDecimal amount, BigDecimal accAmt, BigDecimal accOccAmt, String accHandleType, String accOccHandleType) {
        return AccountFlowAccAmtParam.builder().amount(amount).accAmt(accAmt).accOccAmt(accOccAmt).accHandleType(accHandleType).accOccHandleType(accOccHandleType).build();
    }

    @Override
    public AccountFlowAccAmtVO handleAccAmt(AccountFlowAccAmtParam accAmtParam) {
        if (StringUtils.isBlank((CharSequence)accAmtParam.getAccHandleType())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u6237\u91d1\u989d\u5904\u7406\u7c7b\u578b\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)accAmtParam.getAccOccHandleType())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u6237\u5360\u7528\u91d1\u989d\u5904\u7406\u7c7b\u578b\u4e3a\u7a7a!");
        }
        AccountFlowAccAmtVO accountFlowAccAmtVO = new AccountFlowAccAmtVO();
        BigDecimal amount = Objects.isNull(accAmtParam.getAmount()) ? BigDecimal.ZERO : accAmtParam.getAmount();
        BigDecimal accAmt = Objects.isNull(accAmtParam.getAccAmt()) ? BigDecimal.ZERO : accAmtParam.getAccAmt();
        BigDecimal accOccAmt = Objects.isNull(accAmtParam.getAccOccAmt()) ? BigDecimal.ZERO : accAmtParam.getAccOccAmt();
        switch (accAmtParam.getAccHandleType()) {
            case "EQU": {
                accountFlowAccAmtVO.setAccAmt(accAmt);
                break;
            }
            case "ADD": {
                accountFlowAccAmtVO.setAccAmt(accAmt.add(amount));
                break;
            }
            case "SUB": {
                accountFlowAccAmtVO.setAccAmt(accAmt.subtract(amount));
                break;
            }
            case "EMP": {
                accountFlowAccAmtVO.setAccAmt(BigDecimal.ZERO);
                break;
            }
        }
        switch (accAmtParam.getAccOccHandleType()) {
            case "EQU": {
                accountFlowAccAmtVO.setAccOccAmt(accOccAmt);
                break;
            }
            case "ADD": {
                accountFlowAccAmtVO.setAccOccAmt(accOccAmt.add(amount));
                break;
            }
            case "SUB": {
                accountFlowAccAmtVO.setAccOccAmt(accOccAmt.subtract(amount));
                break;
            }
            case "EMP": {
                accountFlowAccAmtVO.setAccOccAmt(BigDecimal.ZERO);
                break;
            }
        }
        return accountFlowAccAmtVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> saveAccountFlowBatch(List<AccountFlowDO> doList) {
        return this.accountFlowRepo.saveAll(doList).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveAccountFlow(AccountFlowDO accountFlowDO) {
        return ((AccountFlowDO)((Object)this.accountFlowRepo.save((Object)accountFlowDO))).getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveAccountAndFlow(AccountFlowParam accountFlowParam) {
        AccountFlowDO accountFlowDO = AccountFlowConvert.INSTANCE.paramToDo(accountFlowParam);
        Long id = ((AccountFlowDO)((Object)this.accountFlowRepo.save((Object)accountFlowDO))).getId();
        this.accountService.updateAmtByCode(accountFlowDO.getAccCode(), accountFlowDO.getAccAmt(), accountFlowDO.getAccOccAmt());
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> saveParamBatch(List<AccountFlowParam> paramList) {
        List accountFlowDOList = paramList.stream().map(AccountFlowConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        return this.accountFlowRepo.saveAll(accountFlowDOList).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void defaultAssignment(AccountFlowParam accountFlowParam) {
        String flowNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_FLOW_NO.getCode());
        accountFlowParam.setFlowNo(flowNo);
        String accIoType = this.accIoTypeAssignment(accountFlowParam);
        accountFlowParam.setAccIoType(accIoType);
        if (StringUtils.isEmpty((CharSequence)accountFlowParam.getSourcePlatform())) {
            accountFlowParam.setSourcePlatform(UdcEnum.FIN_SOURCE_PLATFORM_TYPE_OTHER.getValueCode());
        }
    }

    private String accIoTypeAssignment(AccountFlowParam accountFlowParam) {
        String accIoType = "NO";
        if (FinConstant.ADD_TRANSACTION_TYPE.contains(accountFlowParam.getTransactionType())) {
            return "ADD";
        }
        if (FinConstant.SUB_TRANSACTION_TYPE.contains(accountFlowParam.getTransactionType())) {
            return "SUB";
        }
        if (FinConstant.NO_ADD_TRANSACTION_TYPE.contains(accountFlowParam.getTransactionType())) {
            return "NO_ADD";
        }
        if (FinConstant.NO_SUB_TRANSACTION_TYPE.contains(accountFlowParam.getTransactionType())) {
            return "NO_SUB";
        }
        if (Objects.equals(accountFlowParam.getDataSource(), UdcEnum.FIN_DATA_SOURCE_TYPE_TZD03.getValueCode())) {
            accIoType = Objects.equals(accountFlowParam.getTransactionType(), UdcEnum.FIN_TRANSACTION_TYPE_TZDSF.getValueCode()) ? "NO_SUB" : "SUB";
            return accIoType;
        }
        if (Objects.equals(accountFlowParam.getDataSource(), UdcEnum.FIN_DATA_SOURCE_TYPE_TZD04.getValueCode())) {
            return "ADD";
        }
        if (Objects.equals(accountFlowParam.getDataSource(), UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode())) {
            if (Objects.equals(accountFlowParam.getTransactionType(), UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode())) {
                accIoType = "NO_SUB";
            } else if (Objects.equals(accountFlowParam.getSplitType(), "ADJUST_APPROVE_FROM")) {
                accIoType = "SUB";
            } else if (Objects.equals(accountFlowParam.getSplitType(), "ADJUST_APPROVE_TO")) {
                accIoType = "ADD";
            }
            return accIoType;
        }
        return accIoType;
    }

    @Override
    public BigDecimal plusOrMinus(String accIoType) {
        if (StringUtils.isBlank((CharSequence)accIoType)) {
            return BigDecimal.ONE;
        }
        if (FinConstant.ACC_IO_TYPE_ADD_LIST.contains(accIoType)) {
            return BigDecimal.ONE;
        }
        if (FinConstant.ACC_IO_TYPE_SUB_LIST.contains(accIoType)) {
            return BigDecimal.ONE.negate();
        }
        return BigDecimal.ONE;
    }

    @Override
    public Boolean plusOrMinus02(String accIoType) {
        if (StringUtils.isBlank((CharSequence)accIoType)) {
            return false;
        }
        if (FinConstant.ACC_IO_TYPE_ADD_LIST.contains(accIoType)) {
            return false;
        }
        if (FinConstant.ACC_IO_TYPE_SUB_LIST.contains(accIoType)) {
            return true;
        }
        return false;
    }

    @Override
    public boolean judgeZcAccType(String accType) {
        return Objects.equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode(), accType) || Objects.equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode(), accType);
    }

    @Override
    public boolean judgePjAccType(String accType) {
        return Objects.equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode(), accType) || Objects.equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode(), accType);
    }

    @Override
    public boolean judgeFjbAccType(String accType) {
        return Objects.equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode(), accType);
    }

    @Override
    public boolean judgeTcAccType(String accType) {
        return Objects.equals(UdcEnum.FIN_ACCOUNT_TYPE_TCZH.getValueCode(), accType);
    }

    @Override
    public LocalDate transitionYearMonthStr(String yearMonthStr) {
        if (StringUtils.isBlank((CharSequence)yearMonthStr)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e74\u6708\u683c\u5f0f\u5b57\u7b26\u4e32\u4e3a\u7a7a!");
        }
        String[] yearMonthParams = yearMonthStr.split("-");
        if (yearMonthParams.length != 2) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e74\u6708\u683c\u5f0f\u5b57\u7b26\u4e32\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        int year = Integer.parseInt(yearMonthParams[0]);
        int month = Integer.parseInt(yearMonthParams[1]);
        return LocalDate.of(year, month, 1);
    }

    @Override
    public void splicTransactionTimeSection(LocalDate localDate, AccountFlowPageParam pageParam) {
        if (Objects.isNull(localDate)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e74\u6708\u65e5\u683c\u5f0f\u7684\u65e5\u671f\u4e3a\u7a7a!");
        }
        LocalDateTime minTime = LocalDateTime.of(localDate.with(TemporalAdjusters.firstDayOfMonth()), LocalTime.MIN);
        LocalDateTime maxTime = LocalDateTime.of(localDate.with(TemporalAdjusters.lastDayOfMonth()), LocalTime.MAX);
        pageParam.setTransactionTimeS(minTime);
        pageParam.setTransactionTimeE(maxTime);
    }

    @Override
    public void checkAdjustApprove(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            if (StringUtils.isBlank((CharSequence)param.getSplitType())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u62c6\u5206\u7c7b\u578b\u4e3a\u7a7a!");
            }
        });
    }

    @Override
    public boolean judgeAdjustRelease(String birthOrderType) {
        return !Objects.equals(birthOrderType, "ADJUST_AUTO");
    }
}

