/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.application.service.flow;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowDealerParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.yst.production.fin.application.facade.vo.flow.AccountFlowDealerVO;
import com.elitesland.yst.production.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.yst.production.fin.application.service.flow.AccountFlowCommonService;
import com.elitesland.yst.production.fin.application.service.flow.AccountFlowFjbService;
import com.elitesland.yst.production.fin.application.service.flow.AccountFlowPjService;
import com.elitesland.yst.production.fin.application.service.flow.AccountFlowService;
import com.elitesland.yst.production.fin.application.service.flow.AccountFlowTcService;
import com.elitesland.yst.production.fin.application.service.flow.AccountFlowZcService;
import com.elitesland.yst.production.fin.common.SysNumberGenerator;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.repo.flow.AccountFlowRepo;
import com.elitesland.yst.production.fin.repo.flow.AccountFlowRepoProc;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AccountFlowServiceImpl
implements AccountFlowService {
    private static final Logger log = LoggerFactory.getLogger(AccountFlowServiceImpl.class);
    @Autowired
    private AccountFlowRepo accountFlowRepo;
    @Autowired
    private AccountFlowRepoProc accountFlowRepoProc;
    @Autowired
    private SysNumberGenerator sysNumberGenerator;
    @Autowired
    private AccountFlowZcService accountFlowZcService;
    @Autowired
    private AccountFlowPjService accountFlowPjService;
    @Autowired
    private AccountFlowFjbService accountFlowFjbService;
    @Autowired
    private AccountFlowTcService accountFlowTcService;
    @Autowired
    private AccountFlowCommonService accountFlowCommonService;

    @Override
    @SysCodeProc
    public PagingVO<AccountFlowVO> page(AccountFlowPageParam pageParam) {
        PagingVO<AccountFlowVO> pagingVO = this.accountFlowRepoProc.page(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        return PagingVO.builder().total(pagingVO.getTotal()).records(pagingVO.getRecords()).build();
    }

    @Override
    @SysCodeProc
    public List<AccountFlowVO> selectBySourceAndNo(String dataSource, String sourceNo) {
        if (StringUtils.isEmpty((CharSequence)dataSource)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u6765\u6e90\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)sourceNo)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6765\u6e90\u5355\u53f7\u4e3a\u7a7a!");
        }
        AccountFlowPageParam accountFlowPageParam = new AccountFlowPageParam();
        accountFlowPageParam.setDataSource(dataSource);
        accountFlowPageParam.setSourceNoEq(sourceNo);
        List<AccountFlowVO> accountFlowVOList = this.accountFlowRepoProc.selectListByParam(accountFlowPageParam);
        if (CollectionUtils.isEmpty(accountFlowVOList)) {
            return Collections.emptyList();
        }
        return accountFlowVOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<AccountFlowVO> dealerPage(AccountFlowPageParam pageParam) {
        this.checkMandatoryField02(pageParam);
        if (StringUtils.isNotBlank((CharSequence)pageParam.getYearMonthStr())) {
            LocalDate transactionDate = this.accountFlowCommonService.transitionYearMonthStr(pageParam.getYearMonthStr());
            this.accountFlowCommonService.splicTransactionTimeSection(transactionDate, pageParam);
        }
        pageParam.setAccIoTypeList(Lists.newArrayList((Object[])new String[]{"ADD", "SUB"}));
        PagingVO<AccountFlowVO> pagingVO = this.accountFlowRepoProc.dealerPage(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        return PagingVO.builder().total(pagingVO.getTotal()).records(pagingVO.getRecords()).build();
    }

    @Override
    public AccountFlowDealerVO dealerSelectAmt(AccountFlowPageParam pageParam) {
        this.checkMandatoryField02(pageParam);
        LocalDate transactionDate = this.accountFlowCommonService.transitionYearMonthStr(pageParam.getYearMonthStr());
        this.accountFlowCommonService.splicTransactionTimeSection(transactionDate, pageParam);
        AccountFlowDealerVO accountFlowDealerVO = new AccountFlowDealerVO();
        accountFlowDealerVO.setUseAmt(BigDecimal.ZERO);
        accountFlowDealerVO.setRecordAmt(BigDecimal.ZERO);
        pageParam.setAccIoType("ADD");
        List<AccountFlowVO> addAmtList = this.accountFlowRepoProc.dealerSelectAmt(pageParam);
        if (!CollectionUtils.isEmpty(addAmtList)) {
            BigDecimal recordAmt = addAmtList.stream().map(AccountFlowVO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            accountFlowDealerVO.setRecordAmt(recordAmt);
        }
        pageParam.setAccIoType("SUB");
        List<AccountFlowVO> subAmtList = this.accountFlowRepoProc.dealerSelectAmt(pageParam);
        if (!CollectionUtils.isEmpty(subAmtList)) {
            BigDecimal useAmt = subAmtList.stream().map(AccountFlowVO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            accountFlowDealerVO.setUseAmt(useAmt);
        }
        return accountFlowDealerVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AccountFlowVO save(List<AccountFlowParam> paramList) {
        log.info("\u83b7\u53d6\u6d41\u6c34\u5165\u53c2{}", (Object)JSON.toJSONString(paramList));
        this.checkMandatoryFieldList(paramList);
        this.checkRepeatability(paramList);
        this.distinguishAccType(paramList);
        return new AccountFlowVO();
    }

    private void distinguishAccType(List<AccountFlowParam> paramList) {
        List<AccountFlowParam> accountFlowTcList;
        List<AccountFlowParam> accountFlowFjbList;
        List<AccountFlowParam> accountFlowPjList;
        List<AccountFlowParam> accountFlowZcList = paramList.stream().filter(param -> this.accountFlowCommonService.judgeZcAccType(param.getAccType())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(accountFlowZcList)) {
            this.accountFlowZcService.saveZc(accountFlowZcList);
        }
        if (!CollectionUtils.isEmpty(accountFlowPjList = paramList.stream().filter(param -> this.accountFlowCommonService.judgePjAccType(param.getAccType())).collect(Collectors.toList()))) {
            this.accountFlowPjService.savePj(accountFlowPjList);
        }
        if (!CollectionUtils.isEmpty(accountFlowFjbList = paramList.stream().filter(param -> this.accountFlowCommonService.judgeFjbAccType(param.getAccType())).collect(Collectors.toList()))) {
            this.accountFlowFjbService.saveFjb(accountFlowFjbList);
        }
        if (!CollectionUtils.isEmpty(accountFlowTcList = paramList.stream().filter(param -> this.accountFlowCommonService.judgeTcAccType(param.getAccType())).collect(Collectors.toList()))) {
            this.accountFlowTcService.saveTc(accountFlowTcList);
        }
    }

    @Override
    public void checkMandatoryFieldList(List<AccountFlowParam> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u6570\u636e\u4e3a\u7a7a!");
        }
        paramList.forEach(accountFlowParam -> this.checkMandatoryField((AccountFlowParam)accountFlowParam));
    }

    @Override
    public void checkMandatoryField(AccountFlowParam param) {
        if (StringUtils.isBlank((CharSequence)param.getAccType())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u8d26\u6237\u7c7b\u578b\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getDataSource())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u6570\u636e\u6765\u6e90\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getTransactionType())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u4ea4\u6613\u7c7b\u578b\u4e3a\u7a7a!");
        }
        if (Objects.isNull(param.getAmount())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u53d1\u751f\u91d1\u989d\u4e3a\u7a7a!");
        }
        if (Objects.isNull(param.getTransactionTime())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getAccCode())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u8d26\u6237\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getAccName())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u8d26\u6237\u540d\u79f0\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getSourceNo())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u6765\u6e90\u5355\u53f7\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getSourceDoc())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u6765\u6e90\u5355\u636e\u4e3a\u7a7a!");
        }
    }

    @Override
    public void checkRepeatability(List<AccountFlowParam> paramList) {
        List dataSourceList = paramList.stream().map(AccountFlowParam::getDataSource).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(dataSourceList) && dataSourceList.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5b58\u5728\u591a\u79cd\u6570\u636e\u6765\u6e90!");
        }
        Map<String, List<AccountFlowParam>> accountFlowListMap = paramList.stream().collect(Collectors.groupingBy(i -> i.getAccType() + "-" + i.getDataSource() + "-" + i.getTransactionType()));
        for (String accountFlowKey : accountFlowListMap.keySet()) {
            List<AccountFlowParam> accountFlowList = accountFlowListMap.get(accountFlowKey);
            String[] keyParams = accountFlowKey.split("-");
            String dataSource = keyParams[1];
            if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode())) {
                List splitTypeList = accountFlowList.stream().map(AccountFlowParam::getSplitType).distinct().collect(Collectors.toList());
                if (Objects.equals(accountFlowList.size(), splitTypeList.size())) continue;
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8c03\u5242\u5355\u6570\u636e\u4e0d\u552f\u4e00\uff0c\u65e0\u6cd5\u5904\u7406!");
            }
            if (CollectionUtils.isEmpty(accountFlowList) || accountFlowList.size() <= 1) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u4e0d\u552f\u4e00\uff0c\u65e0\u6cd5\u5904\u7406!");
        }
    }

    @Override
    public void checkMandatoryField02(AccountFlowPageParam pageParam) {
        if (StringUtils.isBlank((CharSequence)pageParam.getYearMonthStr())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e74\u6708\u65e5\u671f\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)pageParam.getAccCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u6237\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)pageParam.getAccType())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u6237\u7c7b\u578b\u4e3a\u7a7a!");
        }
    }

    @Override
    public AccountFlowDealerVO dealerSelectAccAmt(AccountFlowDealerParam param) {
        AccountFlowDealerVO accountFlowDealerVO = new AccountFlowDealerVO();
        accountFlowDealerVO.setCzAccAmt(BigDecimal.ZERO);
        accountFlowDealerVO.setFlAccAmt(BigDecimal.ZERO);
        Optional<AccountFlowVO> czOptional = this.accountFlowCommonService.selectByAccCode(param.getCzAccCode());
        czOptional.ifPresent(accountFlowVO -> accountFlowDealerVO.setCzAccAmt(accountFlowVO.getAccAmt()));
        Optional<AccountFlowVO> flOptional = this.accountFlowCommonService.selectByAccCode(param.getFlAccCode());
        flOptional.ifPresent(accountFlowVO -> accountFlowDealerVO.setFlAccAmt(accountFlowVO.getAccAmt()));
        return accountFlowDealerVO;
    }
}

