/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.application.service.paytype;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.application.convert.paytype.PayTypeConvert;
import com.elitesland.yst.production.fin.application.facade.param.paytype.PayTypeSaveParam;
import com.elitesland.yst.production.fin.application.facade.vo.paytype.PayTypeVO;
import com.elitesland.yst.production.fin.application.service.paytype.PayTypeService;
import com.elitesland.yst.production.fin.domain.entity.paytype.PayType;
import com.elitesland.yst.production.fin.domain.param.paytype.PayTypePageParam;
import com.elitesland.yst.production.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.yst.production.fin.domain.service.paytype.PayTypeDomainService;
import com.elitesland.yst.production.fin.domain.service.paytype.PayTypeOuDomainService;
import com.elitesland.yst.production.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.yst.production.fin.infr.dto.paytype.PayTypeDTO;
import com.elitesland.yst.production.fin.infr.dto.paytype.PayTypeOuDTO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayTypeServiceImpl
implements PayTypeService {
    private final PayTypeDomainService payTypeDomainService;
    private final PayTypeOuDomainService payTypeOuDomainService;
    private final PayOrderDomainService payOrderDomainService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> makeDefault(Long id) {
        return ApiResult.ok((Object)this.payTypeDomainService.makeDefault(id));
    }

    @Override
    public ApiResult<PagingVO<PayTypeVO>> page(PayTypePageParam payTypePageParam) {
        PagingVO<PayTypeDTO> page = this.payTypeDomainService.page(payTypePageParam);
        return ApiResult.ok(PayTypeConvert.INSTANCE.convertPage(page));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> enable(List<Long> ids) {
        List<PayTypeOuDTO> payTypeOuDTOS = this.payTypeOuDomainService.queryByPayTypeIds(ids);
        Map<Long, PayTypeDTO> dtoMap = this.payTypeDomainService.queryByIds(ids).stream().collect(Collectors.toMap(PayTypeDTO::getId, t -> t));
        Map<Long, List<PayTypeOuDTO>> ouMap = payTypeOuDTOS.stream().collect(Collectors.groupingBy(PayTypeOuDTO::getPayTypeId));
        PayTypeServiceImpl.check(dtoMap, ouMap);
        return ApiResult.ok(this.payTypeDomainService.enable(ids));
    }

    private static void check(Map<Long, PayTypeDTO> dtoMap, Map<Long, List<PayTypeOuDTO>> ouMap) {
        if (CollUtil.isEmpty(ouMap)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u5206\u914d\u516c\u53f8\u4fe1\u606f,\u8bf7\u5206\u914d\u540e\u518d\u542f\u7528");
        }
        for (Map.Entry<Long, List<PayTypeOuDTO>> entry : ouMap.entrySet()) {
            if (entry.getValue() != null && dtoMap.get(entry.getKey()) != null && CollectionUtil.isEmpty((Collection)ouMap.get(entry.getKey()))) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7c7b\u578b\u4ee3\u7801" + dtoMap.get(entry.getKey()).getPayTypeCode() + "\u542f\u7528\u524d\u9700\u8981\u5206\u914d\u516c\u53f8");
            }
            if (dtoMap.get(entry.getKey()) == null || !dtoMap.get(entry.getKey()).getEnableFlag().booleanValue()) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u542f\u7528\u72b6\u6001\u4e0d\u5141\u8bb8\u518d\u6b21\u542f\u7528");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> stopEnable(List<Long> ids) {
        return ApiResult.ok(this.payTypeDomainService.stopEnable(ids));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(PayTypeSaveParam payTypeParam) {
        PayType payType = PayTypeConvert.INSTANCE.convert(payTypeParam);
        Long id = this.payTypeDomainService.save(payType);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> delete(List<Long> ids) {
        List<PayTypeOuDTO> payTypeOuDTOS = this.payTypeOuDomainService.queryByPayTypeIds(ids);
        Map<Long, List<PayTypeOuDTO>> typeOuDTOMap = payTypeOuDTOS.stream().collect(Collectors.groupingBy(PayTypeOuDTO::getPayTypeId));
        Map<Long, List<PayOrderDTO>> orderMap = this.payOrderDomainService.queryByPayTypeId(ids).stream().collect(Collectors.groupingBy(PayOrderDTO::getPayTypeId));
        for (Map.Entry<Long, List<PayTypeOuDTO>> entry : typeOuDTOMap.entrySet()) {
            if (entry.getValue() == null || !CollUtil.isNotEmpty((Collection)entry.getValue())) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8be5\u6570\u636e\u5df2\u5206\u914d\u516c\u53f8!");
        }
        for (Map.Entry<Long, List<Serializable>> entry : orderMap.entrySet()) {
            if (entry.getValue() == null || !CollUtil.isNotEmpty((Collection)entry.getValue())) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8be5\u6570\u636e\u5df2\u5173\u8054\u4ed8\u6b3e\u5355!");
        }
        return ApiResult.ok(this.payTypeDomainService.delete(ids));
    }

    @Override
    public ApiResult<List<PayTypeVO>> findAll() {
        List<PayTypeDTO> all = this.payTypeDomainService.findAll();
        List<PayTypeVO> vo = PayTypeConvert.INSTANCE.dtoToVo(all);
        return ApiResult.ok(vo);
    }

    public PayTypeServiceImpl(PayTypeDomainService payTypeDomainService, PayTypeOuDomainService payTypeOuDomainService, PayOrderDomainService payOrderDomainService) {
        this.payTypeDomainService = payTypeDomainService;
        this.payTypeOuDomainService = payTypeOuDomainService;
        this.payOrderDomainService = payOrderDomainService;
    }
}

