/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.common;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.elitesland.yst.production.fin.common.FinConstant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class LocalDateConverter
implements Converter<LocalDateTime> {
    public Class<LocalDateTime> supportJavaTypeKey() {
        return LocalDateTime.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public LocalDateTime convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        if (cellData.toString().length() > FinConstant.EXCEL_TIME) {
            return LocalDateTime.parse(cellData.getStringValue(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return LocalDateTime.parse(cellData.getStringValue().toString() + " 00:00:00", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public CellData<String> convertToExcelData(LocalDateTime value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        return new CellData(value.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
    }
}

