/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.domain.service.apordertopay;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.yst.production.fin.application.convert.apordertopay.ApOrderToPayConvert;
import com.elitesland.yst.production.fin.domain.entity.apordertopay.ApOrderToPay;
import com.elitesland.yst.production.fin.domain.entity.apordertopay.ApOrderToPayDO;
import com.elitesland.yst.production.fin.domain.service.apordertopay.ApOrderToPayDomainService;
import com.elitesland.yst.production.fin.infr.dto.apordertopay.ApOrderToPayDTO;
import com.elitesland.yst.production.fin.infr.repo.apordertopay.ApOrderToPayRepo;
import com.elitesland.yst.production.fin.infr.repo.apordertopay.ApOrderToPayRepoProc;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApOrderToPayDomainServiceImpl
implements ApOrderToPayDomainService {
    private final ApOrderToPayRepo apOrderToPayRepo;
    private final ApOrderToPayRepoProc apOrderToPayRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> save(List<ApOrderToPay> orderToPays) {
        List<ApOrderToPayDO> apOrderToPayDOS = ApOrderToPayConvert.INSTANCE.convertDo(orderToPays);
        orderToPays.forEach(ApOrderToPay::checkNotNull);
        List order = this.apOrderToPayRepo.saveAll(apOrderToPayDOS);
        return order.stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByPayId(Long payId) {
        this.apOrderToPayRepoProc.deleteByPayId(payId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByPayIds(List<Long> payIds) {
        this.apOrderToPayRepoProc.deleteByPayIds(payIds);
    }

    @Override
    public List<ApOrderToPayDTO> queryByApId(List<Long> apIds) {
        return this.apOrderToPayRepoProc.queryByApIds(apIds);
    }

    public ApOrderToPayDomainServiceImpl(ApOrderToPayRepo apOrderToPayRepo, ApOrderToPayRepoProc apOrderToPayRepoProc) {
        this.apOrderToPayRepo = apOrderToPayRepo;
        this.apOrderToPayRepoProc = apOrderToPayRepoProc;
    }
}

