/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.domain.service.saleinv;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.yst.production.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.yst.production.fin.application.facade.param.saleinv.SaleInvParam;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.yst.production.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.yst.production.fin.domain.entity.saleinv.SaleInvDtl;
import com.elitesland.yst.production.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.yst.production.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.yst.production.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.yst.production.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.yst.production.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.yst.production.fin.infr.dto.saleinv.SaleInvdDtlDTO;
import com.elitesland.yst.production.fin.infr.factory.saleinv.SaleInvFactory;
import com.elitesland.yst.production.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.yst.production.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitesland.yst.production.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.yst.production.fin.infr.repo.saleinv.SaleInvRepoProc;
import com.elitesland.yst.production.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.yst.production.fin.infr.repo.saleinv.SaleInvdDtlRepoProc;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleInvDomainServiceImpl
implements SaleInvDomainService {
    public final SaleInvRepoProc saleInvRepoProc;
    public final SaleInvRepo saleInvRepo;
    public final SaleInvDtlRepoProc saleInvDtlRepoProc;
    public final SaleInvDtlRepo saleInvDtlRepo;
    public final SaleInvdDtlRepoProc saleInvdDtlRepoProc;
    public final SaleInvdDtlRepo saleInvdDtlRepo;
    public final SaleInvFactory saleInvFactory;
    private final SeqNumProvider sysNumberRuleService;

    @Override
    public PagingVO<SaleInvDTO> page(SaleInvPageParam saleInvPageParam) {
        PagingVO<SaleInvDTO> res = this.saleInvFactory.page(saleInvPageParam);
        return res;
    }

    @Override
    public SaleInvDTO get(Long id) {
        SaleInvDTO res = this.saleInvRepoProc.get(id);
        return res;
    }

    @Override
    @Transactional
    public Long save(SaleInv saleInv) {
        if (!UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode().equals(saleInv.getOrderState())) {
            throw new BusinessException("\u975e\u8349\u7a3f\u72b6\u6001\u4e0d\u80fd\u65b0\u589e");
        }
        SaleInvDO saleInvDO = this.saveOrUpdate(saleInv);
        return saleInvDO.getId();
    }

    @Override
    @Transactional
    public Long del(List<Long> ids) {
        ids.forEach(x -> {
            SaleInvDTO saleInvDTO = this.saleInvRepoProc.get((Long)x);
            if (!saleInvDTO.getOrderState().equals(UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException("\u975e\u8349\u7a3f\u72b6\u6001\u4e0d\u80fd\u5220\u9664\u64cd\u4f5c");
            }
        });
        Long res = this.saleInvRepoProc.del(ids);
        this.saleInvDtlRepoProc.delByMasId(ids);
        return res;
    }

    @Override
    @Transactional
    public Long update(SaleInv saleInv) {
        if (!UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode().equals(saleInv.getOrderState())) {
            throw new BusinessException("\u975e\u8349\u7a3f\u72b6\u6001\u4e0d\u80fd\u7f16\u8f91");
        }
        SaleInvDO saleInvDO = this.saveOrUpdate(saleInv);
        return saleInvDO.getId();
    }

    @Override
    @Transactional
    public Long submit(SaleInv saleInv) {
        saleInv.setOrderState(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode());
        saleInv.checkAmt();
        saleInv.checkAmtSum();
        SaleInvDO saleInvDO = this.saveOrUpdate(saleInv);
        return saleInvDO.getId();
    }

    @Override
    public List<SaleInvdDtlDTO> getInvdLists(Long masId) {
        List<SaleInvdDtlDTO> list = this.saleInvdDtlRepoProc.getList(masId);
        return list;
    }

    @Override
    @Transactional
    public Long updateInvInfo(SaleInvParam saleInvParam) {
        Long res = this.saleInvRepoProc.updateInvInfo(saleInvParam);
        return res;
    }

    @Override
    @Transactional
    public void updateWorkInfo(ProcessInfo processInfo, Long resId) {
        this.saleInvRepoProc.updateWorkInfo(processInfo, resId);
    }

    @Transactional
    public SaleInvDO saveOrUpdate(SaleInv saleInv) {
        saleInv.check();
        saleInv.checkDtl();
        if (CharSequenceUtil.isBlank((CharSequence)saleInv.getApplyNo())) {
            String applyNo = this.sysNumberRuleService.generateCode("yst-fin", "XXFP", null);
            saleInv.setApplyNo(applyNo);
        }
        SaleInvDO saleInvDO = (SaleInvDO)this.saleInvRepo.save(SaleInvConvert.INSTANCE.convert(saleInv));
        this.saleInvDtlRepoProc.delByMasId(Lists.newArrayList((Object[])new Long[]{saleInvDO.getId()}));
        List<SaleInvDtl> saleInvDtls = saleInv.getSaleInvDtls();
        List<SaleInvDtlDO> saleInvDtlDOS = SaleInvConvert.INSTANCE.convertListDO(saleInvDtls);
        saleInvDtlDOS.stream().forEach(x -> {
            x.setMasId(saleInvDO.getId());
            this.saleInvDtlRepo.save(x);
        });
        if (CollUtil.isNotEmpty(saleInv.getSaleInvdDtls())) {
            List<SaleInvdDtlDO> saleInvdDtlDOS = SaleInvConvert.INSTANCE.convertInvd(saleInv.getSaleInvdDtls());
            saleInvdDtlDOS.stream().forEach(x -> {
                x.setMasId(saleInvDO.getId());
                this.saleInvdDtlRepo.save(x);
            });
        }
        return saleInvDO;
    }

    public SaleInvDomainServiceImpl(SaleInvRepoProc saleInvRepoProc, SaleInvRepo saleInvRepo, SaleInvDtlRepoProc saleInvDtlRepoProc, SaleInvDtlRepo saleInvDtlRepo, SaleInvdDtlRepoProc saleInvdDtlRepoProc, SaleInvdDtlRepo saleInvdDtlRepo, SaleInvFactory saleInvFactory, SeqNumProvider sysNumberRuleService) {
        this.saleInvRepoProc = saleInvRepoProc;
        this.saleInvRepo = saleInvRepo;
        this.saleInvDtlRepoProc = saleInvDtlRepoProc;
        this.saleInvDtlRepo = saleInvDtlRepo;
        this.saleInvdDtlRepoProc = saleInvdDtlRepoProc;
        this.saleInvdDtlRepo = saleInvdDtlRepo;
        this.saleInvFactory = saleInvFactory;
        this.sysNumberRuleService = sysNumberRuleService;
    }
}

