/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.infr.repo.aptype;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.domain.entity.aptype.QApTypeDO;
import com.elitesland.yst.production.fin.domain.param.aptype.ApTypePageParam;
import com.elitesland.yst.production.fin.infr.dto.aptype.ApTypeDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ApTypeRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QApTypeDO qApTypeDO = QApTypeDO.apTypeDO;

    public PagingVO<ApTypeDTO> page(ApTypePageParam apType, List<Long> ids) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)apType.getApTypeCode())) {
            predicates.add(this.qApTypeDO.apTypeCode.like("%" + apType.getApTypeCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)apType.getApTypeName())) {
            predicates.add(this.qApTypeDO.apTypeName.like("%" + apType.getApTypeName() + "%"));
        }
        if (null != apType.getOuId()) {
            if (CollUtil.isNotEmpty(ids)) {
                predicates.add(this.qApTypeDO.id.in(ids));
            } else {
                return new PagingVO();
            }
        }
        predicates.add(this.qApTypeDO.deleteFlag.eq((Object)0));
        JPAQuery query = (JPAQuery)this.select(ApTypeDTO.class).where(ExpressionUtils.allOf(predicates));
        apType.setPaging(query);
        apType.fillOrders(query, this.qApTypeDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public <T> JPAQuery<T> select(Class<T> T) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(T, (Expression[])new Expression[]{this.qApTypeDO.id, this.qApTypeDO.apTypeCode, this.qApTypeDO.apTypeName, this.qApTypeDO.enableFlag, this.qApTypeDO.defaultFlag, this.qApTypeDO.createTime})).from((EntityPath)this.qApTypeDO);
    }

    public void updateEnableFlag(List<Long> ids, Boolean enable) {
        this.jpaQueryFactory.update((EntityPath)this.qApTypeDO).set((Path)this.qApTypeDO.enableFlag, (Object)enable).where(new Predicate[]{this.qApTypeDO.id.in(ids)}).execute();
    }

    public Long updateDef() {
        long execute = this.jpaQueryFactory.update((EntityPath)this.qApTypeDO).set((Path)this.qApTypeDO.defaultFlag, (Object)false).where(new Predicate[]{this.qApTypeDO.defaultFlag.isTrue()}).execute();
        return execute;
    }

    public Long updateDefById(Long id) {
        long execute = this.jpaQueryFactory.update((EntityPath)this.qApTypeDO).set((Path)this.qApTypeDO.defaultFlag, (Object)true).where(new Predicate[]{this.qApTypeDO.id.eq((Object)id)}).execute();
        return execute;
    }

    public Long del(Long id) {
        long execute = this.jpaQueryFactory.delete((EntityPath)this.qApTypeDO).where(new Predicate[]{this.qApTypeDO.id.eq((Object)id)}).execute();
        return execute;
    }

    public ApTypeDTO findById(Long id) {
        ApTypeDTO apTypeDTO = (ApTypeDTO)((JPAQuery)this.select(ApTypeDTO.class).where((Predicate)this.qApTypeDO.id.eq((Object)id))).fetchOne();
        return apTypeDTO;
    }

    public Boolean isFir() {
        long res = ((JPAQuery)this.select(ApTypeDTO.class).where((Predicate)this.qApTypeDO.deleteFlag.eq((Object)0))).fetchCount();
        return res == 0L;
    }

    public List<ApTypeDTO> findByIds(List<Long> ids) {
        List res = ((JPAQuery)this.select(ApTypeDTO.class).where((Predicate)this.qApTypeDO.id.in(ids))).fetch();
        return res;
    }

    public Boolean existsByApTypeCode(String apTypeCode) {
        long count = ((JPAQuery)this.select(ApTypeDTO.class).where((Predicate)this.qApTypeDO.apTypeCode.eq((Object)apTypeCode))).fetchCount();
        return count > 0L;
    }

    public Boolean existsByApTypeName(String apTypeName) {
        long count = ((JPAQuery)this.select(ApTypeDTO.class).where((Predicate)this.qApTypeDO.apTypeName.eq((Object)apTypeName))).fetchCount();
        return count > 0L;
    }

    public ApTypeDTO getDef() {
        ApTypeDTO apTypeDTO = (ApTypeDTO)((JPAQuery)((JPAQuery)((JPAQuery)this.select(ApTypeDTO.class).where((Predicate)this.qApTypeDO.defaultFlag.eq(Boolean.valueOf(true)))).where((Predicate)this.qApTypeDO.deleteFlag.eq((Object)0))).where((Predicate)this.qApTypeDO.enableFlag.eq(Boolean.valueOf(true)))).fetchOne();
        return apTypeDTO;
    }

    public List<ApTypeDTO> getList() {
        List res = ((JPAQuery)((JPAQuery)this.select(ApTypeDTO.class).where((Predicate)this.qApTypeDO.deleteFlag.eq((Object)0))).where((Predicate)this.qApTypeDO.enableFlag.eq(Boolean.valueOf(true)))).fetch();
        return res;
    }

    public ApTypeRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

