package com.elitesland.yst.production.fin.application.facade.param.cgorder;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;

/**
 * 充值单;
 * @author : http://www.chiner.pro
 * @date : 2023-2-20
 */
@Data
@ApiModel(description = "充值单")
public class CgOrderPageParam extends AbstractOrderQueryParam{

    private static final long serialVersionUID = -5534428658178696764L;
    @ApiModelProperty("主键ID")
    private List<Long> ids;

    @ApiModelProperty("单号")
    private String docNo;

    @ApiModelProperty("状态")
    private List<String> state;

    @ApiModelProperty("单据类型")
    private List<String> type;

    @ApiModelProperty("收款银行名称")
    private String recBankName;

    @ApiModelProperty("收款银行账户")
    private String recBankAcc;

    @ApiModelProperty("收款方式")
    private List<String> recType;

    @ApiModelProperty("汇款开户行")
    private String payOpenBank;

    @ApiModelProperty("汇款银行账户")
    private String payBankAcc;

    @ApiModelProperty("汇款时间起始")
    private LocalDateTime cgTimeS;

    @ApiModelProperty("汇款时间截至")
    private LocalDateTime cgTimeE;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核人id")
    private Long auditUserId;

    @ApiModelProperty("审核时间起始")
    private LocalDateTime auditTimeS;

    @ApiModelProperty("审核时间截至")
    private LocalDateTime auditTimeE;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejectReason;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源id")
    private Long sourceId;

    @ApiModelProperty("金额从")
    private BigDecimal amtFrom;

    @ApiModelProperty("来源至")
    private BigDecimal amtTo;

    @ApiModelProperty("充值类型")
    private String cgType;

    @ApiModelProperty("是否删除  false=未删除")
    private Boolean delWeb;
}