package com.elitesland.yst.production.fin.application.web.paytype;

import com.elitesland.yst.production.fin.application.facade.param.paytype.PayTypeOuParam;
import com.elitesland.yst.production.fin.application.facade.param.paytype.PayTypeSaveParam;
import com.elitesland.yst.production.fin.application.facade.vo.paytype.PayTypeOuVO;
import com.elitesland.yst.production.fin.application.facade.vo.paytype.PayTypeVO;
import com.elitesland.yst.production.fin.application.service.paytype.PayTypeOuService;
import com.elitesland.yst.production.fin.application.service.paytype.PayTypeService;
import com.elitesland.yst.production.fin.domain.param.paytype.PayTypeOuPageParam;
import com.elitesland.yst.production.fin.domain.param.paytype.PayTypePageParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author zhiyu.he
 * @version V1.0
 * @package com.elitesland.yst.production.fin.application.web.paytype
 * @date 2022/3/10 14:52
 */

@RestController
@RequestMapping("/fin/payType")
@RequiredArgsConstructor
@Api(value = "付款类型定义", tags = {"付款类型定义"})
public class PayTypeController {

    private final PayTypeService payTypeService;

    private final PayTypeOuService payTypeOuService;

    @PostMapping("page")
    @ApiOperation("分页查询付款单类型定义")
    public ApiResult<PagingVO<PayTypeVO>> page(@RequestBody PayTypePageParam payTypePageParam) {
        return payTypeService.page(payTypePageParam);
    }

    @GetMapping("findAll")
    @ApiOperation("下拉框-查询所有付款单类型定义")
    public ApiResult<List<PayTypeVO>> findAll() {
        return payTypeService.findAll();
    }

    @DeleteMapping("delete")
    @ApiOperation("删除付款单类型定义")
    public ApiResult<List<Long>> delete(@RequestBody List<Long> ids) {
        return payTypeService.delete(ids);
    }

    @PutMapping("makeDefault/{id}")
    @ApiOperation("默认付款单类型定义")
    public ApiResult<Long> makeDefault(@PathVariable("id") Long id) {
        return payTypeService.makeDefault(id);
    }

    @PutMapping("enable")
    @ApiOperation("启用定义数据")
    public ApiResult<List<Long>> enable(@RequestBody List<Long> ids) {
        return payTypeService.enable(ids);
    }

    @PutMapping("stop")
    @ApiOperation("停用定义数据")
    public ApiResult<List<Long>> stop(@RequestBody List<Long> ids) {
        return payTypeService.stopEnable(ids);
    }

    @PostMapping("save")
    @ApiOperation("新增付款单类型定义")
    public ApiResult<Long> save(@RequestBody PayTypeSaveParam payTypeSaveParam) {
        return payTypeService.save(payTypeSaveParam);
    }

    @PostMapping("addOu")
    @ApiOperation("分配公司")
    public ApiResult<List<Long>> addOu(@RequestBody PayTypeOuParam param) {
        return payTypeOuService.addOu(param);
    }

    @PostMapping("cancelOu")
    @ApiOperation("取消分配公司")
    public ApiResult<List<Long>> cancelOu(@RequestBody List<Long> ids) {
        return payTypeOuService.cancelOu(ids);
    }

    @PostMapping("listOu")
    @ApiOperation("根据付款单类型定义ID查询分配公司")
    public ApiResult<PagingVO<PayTypeOuVO>> listOu(@RequestBody PayTypeOuPageParam param) {
        return ApiResult.ok(payTypeOuService.page(param));
    }
}
