package com.elitesland.yst.production.fin.domain.entity.aporder;

import cn.hutool.core.lang.Assert;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import lombok.Data;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.domain.entity.aporder
 * @date 2022/3/16 10:46
 */
@Data
public class ApOrder {

    private Long id;

    private String sourceNo;

    private String apOrderNo;

    private String ouCode;

    private Long ouId;

    private String ouName;

    private String createMode;

    private Long apTypeId;

    private String apTypeName;

    private String apTypeCode;

    private String orderState;

    private LocalDateTime buDate;

    private BigDecimal totalAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal taxAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal exclTaxCurAmt;

    private BigDecimal taxCurAmt;

    private String currCode;

    private String currName;

    private Long auditUserId;

    private String auditUser;

    private LocalDateTime auditDate;

    private BigDecimal exchangeRate;

    private Long operUserId;

    private String operator;

    private Boolean taxFlag;

    private Boolean initFlag;

    private String auditRejection;

    private Long suppId;

    private String suppCode;

    private String suppName;

    private Long buId;

    private String buCode;

    private String buName;

    private String buType;

    private String payMentName;

    private String payMentId;

    private String payMentCode;

    private String localCurrCode;

    private String localCurrName;

    private BigDecimal taxRate;

    private String remark;

    private List<ApOrderDtl> apOrderDtlList;

    private List<ApOrderDtlGroup> apOrderDtlGroupList;

    private String verState;

    private BigDecimal verAmt;

    private String creator;

    private Integer auditDataVersion;

    private String procInstId;

    private ProcInstStatus procInstStatus;

    private LocalDateTime submitTime;

    private LocalDateTime approvedTime;

    private String addrNo;

    private String suppAddrNo;

    /**
     * 校验字段
     */
    public void check() {
        // 手工校验应付单类型
        if (this.createMode.equals(UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode())) {
            Assert.notNull(this.apTypeId, "应付单类型 apTypeId is null");
            Assert.notEmpty(this.apTypeCode, "应付单类型 apTypeCode is null");
            Assert.notEmpty(this.apTypeName, "应付单类型 apTypeName is null");
            // 含税金额
            Assert.notNull(this.totalAmt, "含税金额 totalAmt is null");
            Assert.notNull(this.totalCurAmt, "含税金额 totalCurAmt is null");
            // 不含税金额
            Assert.notNull(this.exclTaxAmt, "不含税金额 exclTaxAmt is null");
            Assert.notNull(this.exclTaxCurAmt, "不含税金额 exclTaxCurAmt is null");
            // 币种
            Assert.notEmpty(this.currName, "币种 currName is null");
            Assert.notEmpty(this.currCode, "币种 currCode is null");
            // 供应商
            Assert.notNull(this.suppId, "供应商 suppId is null");
            Assert.notEmpty(this.suppCode, "供应商 suppCode is null");
            Assert.notEmpty(this.suppName, "供应商 suppName is null");
            // 公司
            Assert.notNull(this.ouId, "公司 ouId is null");
            Assert.notEmpty(this.ouCode, "公司 ouCode is null");
            Assert.notEmpty(this.ouName, "公司 ouName is null");
            // 业务日期
            Assert.notNull(this.buDate, "业务日期 buDate is null");
            // 付款条件
            Assert.notEmpty(this.payMentName, "付款条件 payMent is null");
            // 汇率
            Assert.notNull(this.exchangeRate, "汇率 exchangeRate is null");
            // 本位币(根据公司携带)
            Assert.notNull(this.localCurrCode, "本位币 localCurrCode is null");
            Assert.notNull(this.localCurrName, "本位币 localCurrName is null");
            // 税额
            Assert.notNull(this.taxAmt, "税额 taxAmt is null");
            Assert.notNull(this.taxCurAmt, "税额(本位币) taxCurAmt is null");
        }

        // 对账单
        if (this.createMode.equals(UdcEnum.FIN_AP_DOC_CLS_PACCK.getValueCode())) {
            Assert.notEmpty(this.currName, "币种 currName is null");
            Assert.notEmpty(this.currCode, "币种 currCode is null");
            Assert.notNull(this.suppId, "供应商 suppId is null");
            Assert.notEmpty(this.suppCode, "供应商 suppCode is null");
            Assert.notEmpty(this.suppName, "供应商 suppName is null");
            Assert.notNull(this.ouId, "公司 ouId is null");
            Assert.notEmpty(this.ouCode, "公司 ouCode is null");
            Assert.notEmpty(this.ouName, "公司 ouName is null");
            Assert.notNull(this.buDate, "业务日期 buDate is null");
            Assert.notEmpty(this.payMentName, "付款条件 payMentName is null");
            Assert.notEmpty(this.payMentId, "付款条件 payMentId is null");
            Assert.notEmpty(this.payMentCode, "付款条件 payMentCode is null");
            Assert.notNull(this.localCurrCode, "本位币 localCurrCode is null");
            Assert.notNull(this.localCurrName, "本位币 localCurrName is null");
            Assert.notNull(this.exchangeRate, "汇率 exchangeRate is null");

        }

    }

    /**
     * 验证应付单明细信息
     */
    public void checkDtlList() {
        // 明细信息为空
        Assert.notNull(this.apOrderDtlList, "apOrderDtlList is null");
        // 校验Dtl必填校验
        this.apOrderDtlList.stream().forEach(x -> {
            x.check(this.createMode);
        });
        // 来源为手工
        if (createMode.equals(UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            // 明细汇总为空
            Assert.notNull(this.apOrderDtlGroupList, "apOrderDtlGroupList is null");
            // 校验DtlGroup必填字段
            this.apOrderDtlGroupList.stream().forEach(x -> {
                x.check(this.createMode);
            });
        }

    }

    /**
     * 校验明细行金额数据
     */
    public void checkAmt() {
        Assert.notNull(exchangeRate, "汇率exchangeRate不能为空");
        this.count();
    }

    private void count() {
        for (ApOrderDtl apOrderDtl : apOrderDtlList) {
            Assert.notNull(apOrderDtl.getTaxRate(), "taxRate税率不能为空");
            Assert.notNull(apOrderDtl.getQty(), "qty数量不能为空");
            Assert.notNull(apOrderDtl.getExclTaxPrice(), "exclTaxPrice单价（不含税）不能为空");
            Assert.notNull(apOrderDtl.getPrice(), "price单价不能为空");
            // 税率
            taxRate = apOrderDtl.getTaxRate();
            // 数量
            BigDecimal qty = apOrderDtl.getQty();
            // 单价(不含税)
            BigDecimal exclTaxPrice = apOrderDtl.getExclTaxPrice();
            BigDecimal countPrice = apOrderDtl.getPrice();
            taxCount(apOrderDtl, qty, exclTaxPrice, countPrice);
        }

    }

    private void taxCount(ApOrderDtl apOrderDtl, BigDecimal qty, BigDecimal exclTaxPrice, BigDecimal countPrice) {
        if (taxFlag) {
            exclTaxPrice = countPrice.divide(taxRate.add(new BigDecimal(1)), 6, RoundingMode.HALF_UP);
        } else {
            countPrice = exclTaxPrice.multiply(taxRate.add(new BigDecimal(1))).setScale(6, RoundingMode.HALF_UP);
        }
        // 含税单价 = 不含税单价 *（1+税率）
        if (exclTaxPrice.compareTo(apOrderDtl.getExclTaxPrice()) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税单价不相等!");
        }
        // 含税单价 = 不含税单价 *（1+税率）
        if (countPrice.compareTo(apOrderDtl.getPrice()) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税单价不相等!");
        }
        // 不含税金额=不含税单价*数量
        BigDecimal countExclTaxAmt = exclTaxPrice.multiply(qty).setScale(2, RoundingMode.HALF_UP);
        if (countExclTaxAmt.compareTo(apOrderDtl.getExclTaxAmt()) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行不含税金额不相等!");
        }
        // 税额 =round((不含税金额)*税率),2)
        BigDecimal countTaxAmt = countExclTaxAmt.multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
        if (countTaxAmt.compareTo(apOrderDtl.getTaxAmt()) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额不相等!");
        }
        // 含税金额=不含税金额+税额
        BigDecimal countTotalAmt = countExclTaxAmt.add(countTaxAmt).setScale(2, RoundingMode.HALF_UP);
        if (countTotalAmt.compareTo(apOrderDtl.getTotalAmt()) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税金额不相等!");
        }
        // 不含税金额(本位币)=不含税金额*汇率
        BigDecimal countExclTaxCurAmt = countExclTaxAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
        if (countExclTaxCurAmt.compareTo(apOrderDtl.getExclTaxCurAmt()) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行不含税金额(本位币)不相等!");
        }
        // 税额(本位币)=税额*汇率
        BigDecimal countTaxCurAmt = countTaxAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
        if (countTaxCurAmt.compareTo(apOrderDtl.getTaxCurAmt()) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额(本位币)不相等!");
        }
        // 含税金额(本位币)=不含税金额本位币+税额本位币
        BigDecimal countTotalCurAmt = countExclTaxCurAmt.add(countTaxCurAmt).setScale(2, RoundingMode.HALF_UP);
        if (countTotalCurAmt.compareTo(apOrderDtl.getTotalCurAmt()) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税金额(本位币)不相等!");
        }
    }


    /**
     * 计算对账单来源数据
     */
    public void countByPacck() {

        // 明细金额计算
        for (ApOrderDtl apOrderDtl : apOrderDtlList) {
            Assert.notNull(apOrderDtl.getTaxRate(), "taxRate税率不能为空");
            Assert.notNull(apOrderDtl.getQty(), "qty数量不能为空");
            Assert.notNull(apOrderDtl.getExclTaxPrice(), "exclTaxPrice单价（不含税）不能为空");

            // 税额(本位币)=税额*汇率
            BigDecimal countTaxCurAmt = apOrderDtl.getTaxAmt().multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
            apOrderDtl.setTaxCurAmt(countTaxCurAmt);
            // 不含税金额(本位币)=不含税金额*汇率
            BigDecimal countExclTaxCurAmt = apOrderDtl.getExclTaxAmt().multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
            apOrderDtl.setExclTaxCurAmt(countExclTaxCurAmt);
            // 含税金额(本位币)=不含税金额本位币+税额本位币
            BigDecimal countTotalCurAmt = countExclTaxCurAmt.add(countTaxCurAmt).setScale(2, RoundingMode.HALF_UP);
            apOrderDtl.setTotalCurAmt(countTotalCurAmt);
        }
        // 头部信息计算
        // 税额的总和
        BigDecimal taxAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.taxAmt = taxAmtSum;
        // 税额（本位币）taxCurAmt
        BigDecimal taxCurAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.taxCurAmt = taxCurAmtSum;
        // 不含税金额 exclTaxAmt
        BigDecimal exclTaxAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.exclTaxAmt = exclTaxAmtSum;
        // 不含税金额（本位币）exclTaxCurAmt
        BigDecimal exclTaxCurAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.exclTaxCurAmt = exclTaxCurAmtSum;
        // 含税金额 totalAmt
        BigDecimal totalAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.totalAmt = totalAmtSum;
        // 含税金额（本位币）totalCurAmt
        BigDecimal totalCurAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.totalCurAmt = totalCurAmtSum;
    }

    /**
     * 校验单头/明细/汇总金额
     */
    public void checkAmtSum() {
        // 计算明细的汇总和
        // 数量的总和
        BigDecimal qtySum = this.apOrderDtlList.stream().map(ApOrderDtl::getQty).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 税额的总和
        BigDecimal taxAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 税额（本位币）taxCurAmt
        BigDecimal taxCurAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 不含税金额 exclTaxAmt
        BigDecimal exclTaxAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 不含税金额（本位币）exclTaxCurAmt
        BigDecimal exclTaxCurAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 含税金额 totalAmt
        BigDecimal totalAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 含税金额（本位币）totalCurAmt
        BigDecimal totalCurAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);

        // 对比单头信息与明细总和
        if (totalAmt.compareTo(totalAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税金额之和与单头含税金额不相等!");
        }
        if (totalCurAmt.compareTo(totalCurAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税金额(本位币)之和与单头含税金额(本位币)不相等!");
        }
        if (exclTaxAmt.compareTo(exclTaxAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行不含税金额之和与单头不含税金额不相等!");
        }
        if (exclTaxCurAmt.compareTo(exclTaxCurAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行不含税金额(本位币)之和与单头不含税金额(本位币)不相等!");
        }
        if (taxAmt.compareTo(taxAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额之和与单头税额不相等!");
        }
        if (taxCurAmt.compareTo(taxCurAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额(本位币)之和与单头税额(本位币)不相等!");
        }

        // 取汇总的汇总和
        // 数量的总和
        BigDecimal qtyGroSum = this.apOrderDtlGroupList.stream().map(ApOrderDtlGroup::getQty).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 税额的总和
        BigDecimal taxAmtGroSum = this.apOrderDtlGroupList.stream().map(ApOrderDtlGroup::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 税额（本位币）taxCurAmt
        BigDecimal taxCurAmtGroSum = this.apOrderDtlGroupList.stream().map(ApOrderDtlGroup::getTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 不含税金额 exclTaxAmt
        BigDecimal exclTaxAmtGroSum = this.apOrderDtlGroupList.stream().map(ApOrderDtlGroup::getExclTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 不含税金额（本位币）exclTaxCurAmt
        BigDecimal exclTaxCurAmtGroSum = this.apOrderDtlGroupList.stream().map(ApOrderDtlGroup::getExclTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 含税金额 totalAmt
        BigDecimal totalAmtGroSum = this.apOrderDtlGroupList.stream().map(ApOrderDtlGroup::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 含税金额（本位币）totalCurAmt
        BigDecimal totalCurAmtGroSum = this.apOrderDtlGroupList.stream().map(ApOrderDtlGroup::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);

        // 对比汇总与明细总和
        if (qtyGroSum.compareTo(qtySum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行数量之和与汇总行数量之和不相等!");
        }
        if (totalAmtGroSum.compareTo(totalAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税金额之和与汇总行含税金额之和不相等!");
        }
        if (totalCurAmtGroSum.compareTo(totalCurAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税金额(本位币)之和与汇总行含税金额(本位币)之和不相等!");
        }
        if (exclTaxAmtGroSum.compareTo(exclTaxAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行不含税金额之和与汇总行不含税金额之和不相等!");
        }
        if (exclTaxCurAmtGroSum.compareTo(exclTaxCurAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行不含税金额(本位币)之和与汇总行不含税金额(本位币)之和不相等!");
        }
        if (taxAmtGroSum.compareTo(taxAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额之和与汇总行税额之和不相等!");
        }
        if (taxCurAmtGroSum.compareTo(taxCurAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额(本位币)之和与汇总行税额(本位币)之和不相等!");
        }

    }

    /**
     * 更新接口校验
     */
    public void checkUpdate() {
        Assert.notNull(this.id, "主键id不能为空");
        if (!this.orderState.equals(UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode())) {
            throw new BusinessException("非草稿状态不能进行修改操作");
        }
    }

    public void setDef() {
        this.verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        this.verAmt = new BigDecimal("0");
    }

    public void setPacckDef() {
        this.taxFlag = true;
        this.initFlag = false;
    }


}
