package com.elitesland.yst.production.fin.domain.service.apverrec;

import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitesland.yst.production.fin.application.convert.apverrec.ApVerRecDtlConvert;
import com.elitesland.yst.production.fin.common.FinConstant;
import com.elitesland.yst.production.fin.domain.entity.apverrec.ApVerRecDO;
import com.elitesland.yst.production.fin.domain.entity.apverrec.ApVerRecDtl;
import com.elitesland.yst.production.fin.domain.entity.apverrec.ApVerRecDtlDO;
import com.elitesland.yst.production.fin.infr.dto.apverrec.ApVerRecDtlDTO;
import com.elitesland.yst.production.fin.infr.repo.apverrec.ApVerRecDtlRepo;
import com.elitesland.yst.production.fin.infr.repo.apverrec.ApVerRecDtlRepoProc;
import com.elitesland.yst.production.fin.infr.repo.apverrec.ApVerRecRepo;
import com.elitesland.yst.production.fin.infr.repo.apverrec.ApVerRecRepoProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

/**
 * @author Jason.zhao
 * @date 2022/4/22 15:46
 */
@Service
@RequiredArgsConstructor
public class ApVerRecDomainServiceImpl implements ApVerRecDomainService {

    private final ApVerRecRepo apVerRecRepo;

    private final ApVerRecRepoProc apVerRecRepoProc;

    private final ApVerRecDtlRepo apVerRecDtlRepo;

    private final ApVerRecDtlRepoProc apVerRecDtlRepoProc;

    private final SeqNumProvider sysNumberRuleService;

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long save(List<ApVerRecDtl> apVerRecDtls) {

        BigDecimal apVerAmt = apVerRecDtls.stream()
                .filter(t -> t.getOrderType().equals(FinConstant.AP))
                .map(ApVerRecDtl::getAmt)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payVerAmt = apVerRecDtls.stream()
                .filter(t -> t.getOrderType().equals(FinConstant.PAY))
                .map(ApVerRecDtl::getAmt)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        String verNo = sysNumberRuleService.generateCode(FinConstant.FIN,FinConstant.APVER, null);
        ApVerRecDO apVerRecDO = new ApVerRecDO();
        apVerRecDO.setApVerAmt(apVerAmt);
        apVerRecDO.setPayVerAmt(payVerAmt);
        apVerRecDO.setVerNo(verNo);
        ApVerRecDO saveDO = apVerRecRepo.save(apVerRecDO);
        if (StringUtils.isEmpty(saveDO.toString())) {
            throw new BusinessException("保存应付核销记录汇总表失败");
        }
        Long masId = saveDO.getId();
        List<ApVerRecDtlDO> apVerRecDtlDOS = ApVerRecDtlConvert.INSTANCE.convertDOList(apVerRecDtls);
        apVerRecDtlDOS.stream().forEach(t -> {
                t.setVerNo(verNo);
                t.setMasId(masId);
                t.setVerDate(LocalDateTime.now());
            });
        apVerRecDtlRepo.saveAll(apVerRecDtlDOS);
        return masId;
    }

    @Override
    public Boolean queryByScId(Long scId) {
        return apVerRecDtlRepoProc.queryByScId(scId);
    }

    @Override
    public List<ApVerRecDtlDTO> queryDtlByMasIds(Collection<Long> masIds) {
        return apVerRecDtlRepoProc.queryDtlByMasIds(masIds);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long logicDelDtlByIds(Collection<Long> ids) {
        return apVerRecDtlRepoProc.logicDelByIds(ids);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long logicDelByIds(Collection<Long> ids, String username, Long userId) {
        return apVerRecRepoProc.logicDelByIds(ids,username,userId);
    }

}
