package com.elitesland.yst.production.fin.domain.service.arorder;

import com.elitesland.yst.production.fin.domain.param.arorder.ArOrderDtlPageParam;
import com.elitesland.yst.production.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.yst.production.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.domain.service.arorder
 * @date 2022/4/13 15:00
 */
@Service
@RequiredArgsConstructor
public class ArOrderDtlDomainServiceImpl implements ArOrderDtlDomainService {

    private final ArOrderDtlRepoProc arOrderDtlRepoProc;

    @Override
    public PagingVO<ArOrderDtlDTO> page(ArOrderDtlPageParam arOrderDtlPageParam) {
        PagingVO<ArOrderDtlDTO> res = arOrderDtlRepoProc.page(arOrderDtlPageParam);
        return res;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long del(List<Long> ids) {
        Long res = arOrderDtlRepoProc.del(ids);
        return res;
    }
}
