package com.elitesland.yst.production.fin.application.facade.param.adjusttoorder;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/3/3 20:45
 */
@Data
@ApiModel(description = "调剂单")
public class AdjustToOrderPageParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -3472737792785509542L;

    @ApiModelProperty
    private List<Long> ids;

    @ApiModelProperty("单号")
    private String docNo;

    @ApiModelProperty("状态")
    private List<String> state;

    @ApiModelProperty("记账时间")
    private LocalDateTime recAccTime;

    @ApiModelProperty("从账户名称")
    private String accNameFrom;

    @ApiModelProperty("从账户编码")
    private String accCodeFrom;

    @ApiModelProperty("从账户类型")
    private List<String> accTypeFrom;

    @ApiModelProperty("至账户名称")
    private String accNameTo;

    @ApiModelProperty("至账户编码")
    private String accCodeTo;

    @ApiModelProperty("至账户类型")
    private List<String> accTypeTo;

    @ApiModelProperty("总金额从")
    private BigDecimal totalAmtF;

    @ApiModelProperty("总金额至")
    private BigDecimal totalAmtT;

    @ApiModelProperty("审核时间起始")
    private LocalDateTime auditTimeS;

    @ApiModelProperty("审核时间截至")
    private LocalDateTime auditTimeE;

    @ApiModelProperty("调整原因")
    private List<String> adjReason;
}
