package com.elitesland.yst.production.fin.application.facade.param.flow;

import com.elitesland.yst.production.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 账户流水;
 *
 * @author : http://www.chiner.pro
 * @date : 2023-2-24
 */
@Data
@ApiModel(description = "账户流水")
public class AccountFlowParam extends BaseModelParam {
    private static final long serialVersionUID = -5067931732705888337L;

    @ApiModelProperty("账户类型")
    private String accType;

    @ApiModelProperty("数据来源")
    private String dataSource;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("交易类型")
    private String transactionType;

    @ApiModelProperty("发生金额")
    private BigDecimal amount;

    @ApiModelProperty("交易日期")
    private LocalDateTime transactionTime;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户金额")
    private BigDecimal accAmt;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accOccAmt;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源单据")
    private String sourceDoc;

    @ApiModelProperty("来源平台")
    private String sourcePlatform;

    @ApiModelProperty("账户进出方式")
    private String accIoType;

    @ApiModelProperty("拆分类型")
    private String splitType;

    @ApiModelProperty("生单类型")
    private String birthOrderType;

}
