package com.elitesland.yst.production.fin.application.facade.vo.flow;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import com.elitesland.yst.production.fin.application.facade.base.BaseModelVO;

/**
 * 账户流水;
 *
 * @author : http://www.chiner.pro
 * @date : 2023-2-24
 */
@ApiModel(value = "账户流水", description = "账户流水")
@Data
public class AccountFlowVO extends BaseModelVO {
    private static final long serialVersionUID = 6171624755462812499L;

    @ApiModelProperty("账户类型")
    @SysCode(sys = "yst-fin", mod = "ACCOUNT_TYPE")
    private String accType;
    private String accTypeName;

    @ApiModelProperty("数据来源")
    @SysCode(sys = "yst-fin", mod = "DATA_SOURCE_TYPE")
    private String dataSource;
    private String dataSourceName;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("交易类型")
    @SysCode(sys = "yst-fin", mod = "TRANSACTION_TYPE")
    private String transactionType;
    private String transactionTypeName;

    @ApiModelProperty("发生金额")
    private BigDecimal amount;

    @ApiModelProperty("交易日期")
    private LocalDateTime transactionTime;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户金额")
    private BigDecimal accAmt;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accOccAmt;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源单据")
    @SysCode(sys = "yst-fin", mod = "SOURCE_DOC_TYPE")
    private String sourceDoc;
    private String sourceDocName;

    @ApiModelProperty("来源平台")
    @SysCode(sys = "yst-fin", mod = "SOURCE_PLATFORM_TYPE")
    private String sourcePlatform;
    private String sourcePlatformName;

    @ApiModelProperty("账户进出方式")
    private String accIoType;
}
