package com.elitesland.yst.production.fin.application.service.arorder;

import com.elitesland.yst.production.fin.application.convert.arorder.ArOrderDtlConvert;
import com.elitesland.yst.production.fin.application.facade.vo.arorder.ArOrderDtlVO;
import com.elitesland.yst.production.fin.domain.param.arorder.ArOrderDtlPageParam;
import com.elitesland.yst.production.fin.domain.service.arorder.ArOrderDtlDomainService;
import com.elitesland.yst.production.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.application.service.arorder
 * @date 2022/4/13 14:13
 */
@Service
@RequiredArgsConstructor
public class ArOrderDtlServiceImpl implements ArOrderDtlService {


    private final ArOrderDtlDomainService arOrderDtlDomainService;

    @SysCodeProc
    @Override
    public PagingVO<ArOrderDtlVO> page(ArOrderDtlPageParam arOrderDtlPageParam) {
        PagingVO<ArOrderDtlDTO> page = arOrderDtlDomainService.page(arOrderDtlPageParam);
        return ArOrderDtlConvert.INSTANCE.convertPage(page);
    }
}
